/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.dnd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dnd.GridDropLocation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

@DomEvent(value="grid-drop")
public class GridDropEvent<T>
extends ComponentEvent<Grid<T>> {
    private final T dropTargetItem;
    private final GridDropLocation dropLocation;
    private final Map<String, String> data = new HashMap<String, String>();

    public GridDropEvent(Grid<T> source, boolean fromClient, @EventData(value="event.detail.dropTargetItem") ObjectNode item, @EventData(value="event.detail.dropLocation") String dropLocation, @EventData(value="event.detail.dragData") ArrayNode dragData) {
        super(source, fromClient);
        IntStream.range(0, dragData.size()).forEach(i -> {
            JsonNode jsonData = dragData.get(i);
            this.data.put(jsonData.get("type").asText(), jsonData.get("data").asText());
        });
        this.dropTargetItem = item != null ? source.getDataCommunicator().getKeyMapper().get(item.get("key").asText()) : null;
        this.dropLocation = Arrays.asList(GridDropLocation.values()).stream().filter(dl -> dl.getClientName().equals(dropLocation)).findFirst().get();
    }

    public Optional<T> getDropTargetItem() {
        return Optional.ofNullable(this.dropTargetItem);
    }

    public GridDropLocation getDropLocation() {
        return this.dropLocation;
    }

    public Optional<String> getDataTransferData(String type) {
        return Optional.ofNullable(this.data.get(type));
    }

    public String getDataTransferText() {
        String text = this.data.get("text");
        if (text == null) {
            text = this.data.get("Text");
        }
        if (text == null) {
            text = this.data.get("text/plain");
        }
        return text;
    }

    public Map<String, String> getDataTransferData() {
        return Collections.unmodifiableMap(this.data);
    }
}

