/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.editor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.ExecutionContext;
import java.io.Serializable;
import java.util.Optional;

public class EditorRenderer<T>
extends Renderer<T>
implements DataGenerator<T> {
    private final Editor<T> editor;
    private final String columnInternalId;
    private Element editorContainer;
    private SerializableFunction<T, ? extends Component> componentFunction;
    private Component component;
    private Component emptyComponent;

    public EditorRenderer(Editor<T> editor, String columnInternalId) {
        this.editor = editor;
        this.columnInternalId = columnInternalId;
    }

    public void setComponentFunction(SerializableFunction<T, ? extends Component> componentFunction) {
        this.componentFunction = componentFunction;
    }

    public void generateData(T item, ObjectNode jsonObject) {
        if (this.editor.isOpen() && this.component != null) {
            int nodeId = this.getComponentNodeId(this.component);
            jsonObject.put("_" + this.columnInternalId + "_editor", nodeId);
        }
    }

    private void buildComponent(T item) {
        if (this.componentFunction != null) {
            this.setComponent((Component)this.componentFunction.apply(item));
        } else {
            this.setComponent(null);
        }
    }

    private void setComponent(Component newComponent) {
        if (this.component != null) {
            if (this.component.equals(newComponent)) {
                return;
            }
            if (this.component.getElement().getParent().equals((Object)this.editorContainer)) {
                this.editorContainer.removeChild(new Element[]{this.component.getElement()});
            }
        }
        if (newComponent == null) {
            newComponent = this.getOrCreateEmptyComponent();
        }
        this.editorContainer.appendChild(new Element[]{newComponent.getElement()});
        this.component = newComponent;
    }

    private Component getOrCreateEmptyComponent() {
        if (this.emptyComponent == null) {
            this.emptyComponent = new Span();
        }
        return this.emptyComponent;
    }

    public void refreshData(T item) {
        if (this.editor.isOpen()) {
            this.buildComponent(item);
        }
    }

    public Rendering<T> render(Element container, DataKeyMapper<T> keyMapper, String rendererName) {
        this.editorContainer = this.createEditorContainer();
        container.appendVirtualChild(new Element[]{this.editorContainer});
        this.runBeforeClientResponse(container, (SerializableConsumer<ExecutionContext>)(SerializableConsumer & Serializable)context -> this.setupEditorRenderer(container, (ExecutionContext)context));
        container.addAttachListener((ElementAttachListener & Serializable)event -> this.runBeforeClientResponse(container, (SerializableConsumer<ExecutionContext>)(SerializableConsumer & Serializable)context -> this.setupEditorRenderer(container, (ExecutionContext)context)));
        return new EditorRendering();
    }

    private void setupEditorRenderer(Element container, ExecutionContext context) {
        String appId = context.getUI().getInternals().getAppId();
        container.executeJs("const originalRender = this.renderer;this.renderer = (root, container, model) => {const editingChanged = root.__editing !== model.item._editing;root.__editing = model.item._editing;if (editingChanged) {delete root._$litPart$; root.innerHTML = ''}if (root.__editing) { Vaadin.FlowComponentHost.setChildNodes('" + appId + "', [model.item._" + this.columnInternalId + "_editor], root); }else if (originalRender) { originalRender(root, container, model) }else { this._defaultRenderer(root, container, model) }};", new Serializable[0]);
    }

    private void runBeforeClientResponse(Element container, SerializableConsumer<ExecutionContext> execution) {
        container.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(container.getNode(), execution));
    }

    int getComponentNodeId(Component component) {
        return component.getElement().getNode().getId();
    }

    Element createEditorContainer() {
        return ElementFactory.createDiv();
    }

    private class EditorRendering
    implements Rendering<T> {
        private EditorRendering() {
        }

        public Optional<DataGenerator<T>> getDataGenerator() {
            return Optional.of(EditorRenderer.this);
        }
    }
}

