/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.data.selection.SingleSelectionEvent;
import com.vaadin.flow.data.selection.SingleSelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import tools.jackson.databind.node.ObjectNode;

public abstract class AbstractGridSingleSelectionModel<T>
extends Grid.AbstractGridExtension<T>
implements GridSingleSelectionModel<T> {
    private T selectedItem;
    private boolean deselectAllowed = true;

    public AbstractGridSingleSelectionModel(Grid<T> grid) {
        super(grid);
    }

    @Override
    public void selectFromClient(T item) {
        boolean selectable = this.getGrid().isItemSelectable(item);
        if (this.isSelected(item) || !selectable) {
            return;
        }
        this.doSelect(item, true);
    }

    public void select(T item) {
        if (this.isSelected(item)) {
            return;
        }
        this.doSelect(item, false);
        this.getGrid().doClientSideSelection(Collections.singleton(item));
    }

    @Override
    public void deselectFromClient(T item) {
        boolean selectable = this.getGrid().isItemSelectable(item);
        if (this.isSelected(item) && selectable && this.isDeselectAllowed()) {
            this.doSelect(null, true);
        }
    }

    public void deselect(T item) {
        if (this.isSelected(item)) {
            this.select(null);
        }
    }

    public boolean isSelected(T item) {
        return Objects.equals(this.getItemId(item), this.getItemId(this.selectedItem));
    }

    public Optional<T> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }

    public void setDeselectAllowed(boolean deselectAllowed) {
        this.deselectAllowed = deselectAllowed;
    }

    public boolean isDeselectAllowed() {
        return this.deselectAllowed;
    }

    @Override
    public SingleSelect<Grid<T>, T> asSingleSelect() {
        return new SingleSelect<Grid<T>, T>(){

            public void setValue(T value) {
                AbstractGridSingleSelectionModel.this.setSelectedItem(value);
            }

            public T getValue() {
                return AbstractGridSingleSelectionModel.this.getSelectedItem().orElse(this.getEmptyValue());
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Grid<T>, T>> listener) {
                Objects.requireNonNull(listener, "listener cannot be null");
                ComponentEventListener & Serializable componentEventListener = (ComponentEventListener & Serializable)event -> listener.valueChanged((HasValue.ValueChangeEvent)((AbstractField.ComponentValueChangeEvent)event));
                return ComponentUtil.addListener(AbstractGridSingleSelectionModel.this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener)componentEventListener);
            }

            public Element getElement() {
                return AbstractGridSingleSelectionModel.this.getGrid().getElement();
            }
        };
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener(this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SelectionEvent)event));
    }

    @Override
    public Registration addSingleSelectionListener(SingleSelectionListener<Grid<T>, T> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        return ComponentUtil.addListener(this.getGrid(), SingleSelectionEvent.class, (ComponentEventListener & Serializable)event -> listener.selectionChange((SingleSelectionEvent)event));
    }

    public void generateData(T item, ObjectNode jsonObject) {
        if (this.isSelected(item)) {
            jsonObject.put("selected", true);
        }
    }

    @Override
    protected void remove() {
        super.remove();
        this.deselectAll();
    }

    protected abstract void fireSelectionEvent(SelectionEvent<Grid<T>, T> var1);

    private void doSelect(T item, boolean userOriginated) {
        T oldValue = this.selectedItem;
        this.selectedItem = item;
        this.fireSelectionEvent((SelectionEvent<Grid<T>, T>)new SingleSelectionEvent(this.getGrid(), this.getGrid().asSingleSelect(), oldValue, userOriginated));
    }

    private Object getItemId(T item) {
        return item == null ? null : this.getGrid().getDataCommunicator().getDataProvider().getId(item);
    }
}

