/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle.plugin;

import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.plugin.VaadinPlugin;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/vaadin/gradle/plugin/EngineGenerateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "artifactId", "", "getArtifactId", "()Ljava/lang/String;", "groupId", "getGroupId", "mainClass", "getMainClass", "setMainClass", "(Ljava/lang/String;)V", "engineGenerate", "", "vaadin-gradle-plugin"})
public class EngineGenerateTask
extends DefaultTask {
    @Input
    @NotNull
    private final String groupId;
    @Input
    @NotNull
    private final String artifactId;
    @Input
    @Optional
    @Nullable
    private String mainClass;

    public EngineGenerateTask() {
        this.setGroup("Vaadin");
        this.setDescription("Hilla Generate Task");
        Object[] objectArray = new Object[]{"classes"};
        this.dependsOn(objectArray);
        this.getProject().getTasks().withType(Jar.class, arg_0 -> EngineGenerateTask._init_$lambda$0(1.INSTANCE, arg_0));
        this.groupId = this.getProject().getGroup().toString();
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.artifactId = string;
        this.mainClass = (String)this.getProject().findProperty("mainClass");
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public final String getMainClass() {
        return this.mainClass;
    }

    public final void setMainClass(@Nullable String string) {
        this.mainClass = string;
    }

    @TaskAction
    public final void engineGenerate() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VaadinFlowPluginExtension vaadinExtension = VaadinFlowPluginExtension.Companion.get(project);
        this.getLogger().info("Running the engineGenerate task with effective Vaadin configuration " + vaadinExtension);
        try {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            EngineConfiguration conf = VaadinPlugin.Companion.createEngineConfiguration(project2, vaadinExtension);
            ParserProcessor parserProcessor = new ParserProcessor(conf);
            GeneratorProcessor generatorProcessor = new GeneratorProcessor(conf);
            List endpoints = conf.getBrowserCallableFinder().findBrowserCallables();
            parserProcessor.process(endpoints);
            generatorProcessor.process();
        }
        catch (IOException e) {
            throw new GradleException("Endpoint collection failed", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GradleException("Endpoint collection failed", (Throwable)e);
        }
        catch (GeneratorException e) {
            throw new GradleException("Execution failed", (Throwable)e);
        }
        catch (ParserException e) {
            throw new GradleException("Execution failed", (Throwable)e);
        }
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

