/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.dataprovider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.data.provider.AbstractListDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.tests.MockUIRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractListDataViewListenerTest {
    @Rule
    public MockUIRule ui = new MockUIRule();

    @Test
    public void addItemCountChangeListener_itemsCountChanged_listenersAreNotified() {
        String[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(new ArrayList<String>(Arrays.asList(items)));
        AtomicInteger invocationCounter = new AtomicInteger(0);
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> invocationCounter.incrementAndGet());
        this.ui.add((Component)component);
        dataView.setFilter("one"::equals);
        dataView.setFilter(null);
        dataView.addItemAfter((Object)"item5", (Object)"item4");
        dataView.addItemBefore((Object)"item0", (Object)"item1");
        dataView.addItem((Object)"last");
        dataView.removeItem((Object)"item0");
        this.ui.fakeClientCommunication();
        Assert.assertEquals((String)"Unexpected number of item count change listener invocations occurred", (long)1L, (long)invocationCounter.get());
    }

    @Test
    public void addItemCountChangeListener_itemsCountNotChanged_listenersAreNotNotified() {
        Object[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(items);
        AtomicBoolean invocationChecker = new AtomicBoolean(false);
        this.ui.add((Component)component);
        this.ui.fakeClientCommunication();
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> invocationChecker.getAndSet(true));
        dataView.setSortComparator(String::compareTo);
        this.ui.fakeClientCommunication();
        Assert.assertFalse((String)"Unexpected item count listener invocation", (boolean)invocationChecker.get());
    }

    @Test
    public void addItemCountChangeListener_itemsCountChanged_newItemCountSuppliedInEvent() {
        Object[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(items);
        AtomicBoolean invocationChecker = new AtomicBoolean(false);
        this.ui.add((Component)component);
        this.ui.fakeClientCommunication();
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> {
            Assert.assertEquals((String)"Unexpected item count", (long)1L, (long)event.getItemCount());
            Assert.assertFalse((boolean)event.isItemCountEstimated());
            invocationChecker.set(true);
        });
        dataView.setFilter("item1"::equals);
        this.ui.fakeClientCommunication();
        Assert.assertTrue((String)"Item count change never called", (boolean)invocationChecker.get());
    }

    @Test
    public void setItems_setNewItemsToComponent_filteringAndSortingRemoved() {
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView listDataView = (AbstractListDataView)component.setItems((Object[])new String[]{"item1", "item2", "item3"});
        SerializablePredicate & Serializable filter = "item2"::equals;
        listDataView.setFilter((SerializablePredicate)filter);
        Assert.assertEquals((String)"Unexpected filtered item count", (long)1L, (long)listDataView.getItemCount());
        listDataView = (AbstractListDataView)component.setItems((Object[])new String[]{"item1", "item2", "item3"});
        Assert.assertEquals((String)"Non-filtered item count expected", (long)3L, (long)listDataView.getItemCount());
    }

    protected abstract HasListDataView<String, ? extends AbstractListDataView<String>> getComponent();

    private HasListDataView<String, ? extends AbstractListDataView<String>> getVerifiedComponent() {
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getComponent();
        if (component instanceof Component) {
            return component;
        }
        throw new IllegalArgumentException(String.format("Component subclass is expected, but was given a '%s'", component.getClass().getSimpleName()));
    }
}

