/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public class MockUIRule
extends ExternalResource {
    private UI ui;
    private VaadinSession session;
    private VaadinService service;

    protected void before() {
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        DeploymentConfiguration deploymentConfig = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)deploymentConfig.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)deploymentConfig);
        this.session = new AlwaysLockedVaadinSession(this.service);
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        UI.setCurrent((UI)this.ui);
        VaadinSession.setCurrent((VaadinSession)this.session);
    }

    protected void after() {
        this.ui.removeAll();
        UI.setCurrent(null);
        VaadinSession.setCurrent(null);
    }

    public UI getUI() {
        return this.ui;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    public VaadinService getService() {
        return this.service;
    }

    public void add(Component component) {
        this.ui.add(new Component[]{component});
    }

    public void remove(Component component) {
        this.ui.remove(new Component[]{component});
    }

    public void setLocale(Locale locale) {
        this.ui.setLocale(locale);
    }

    public void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    public List<PendingJavaScriptInvocation> dumpPendingJavaScriptInvocations() {
        this.fakeClientCommunication();
        return this.ui.getInternals().dumpPendingJavaScriptInvocations();
    }

    private static class AlwaysLockedVaadinSession
    extends VaadinSession {
        private final ReentrantLock lock = new ReentrantLock();

        private AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public Future<Void> access(Command command) {
            command.execute();
            return CompletableFuture.completedFuture(null);
        }
    }
}

