/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.VaadinContext;
import org.junit.rules.ExternalResource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class EnableFeatureFlagRule
extends ExternalResource {
    private final Feature feature;
    private FeatureFlags mockFeatureFlags;
    private MockedStatic<FeatureFlags> mockFeatureFlagsStatic;

    public EnableFeatureFlagRule(Feature feature) {
        this.feature = feature;
    }

    public void before() {
        this.mockFeatureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)this.mockFeatureFlags.isEnabled(this.feature)).thenReturn((Object)true);
        Mockito.when((Object)this.mockFeatureFlags.isEnabled(this.feature.getId())).thenReturn((Object)true);
        this.mockFeatureFlagsStatic = Mockito.mockStatic(FeatureFlags.class);
        this.mockFeatureFlagsStatic.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)Mockito.any()))).thenReturn((Object)this.mockFeatureFlags);
    }

    public void after() {
        this.mockFeatureFlagsStatic.close();
    }

    public void disableFeature() {
        Mockito.when((Object)this.mockFeatureFlags.isEnabled(this.feature)).thenReturn((Object)false);
        Mockito.when((Object)this.mockFeatureFlags.isEnabled(this.feature.getId())).thenReturn((Object)false);
    }
}

