/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.dataprovider;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mockito.Mockito;

public class MockUI
extends UI {
    public MockUI() {
        this(MockUI.findOrcreateSession());
    }

    public MockUI(VaadinSession session) {
        this.getInternals().setSession(session);
        MockUI.setCurrent((UI)this);
    }

    protected void init(VaadinRequest request) {
    }

    private static VaadinSession findOrcreateSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            MockService service = (MockService)((Object)Mockito.mock(MockService.class));
            Mockito.when((Object)service.getRouteRegistry()).thenReturn((Object)((RouteRegistry)Mockito.mock(RouteRegistry.class)));
            session = new AlwaysLockedVaadinSession((VaadinService)service);
            VaadinSession.setCurrent((VaadinSession)session);
        }
        return session;
    }

    private static class MockService
    extends VaadinServletService {
        private MockService() {
        }

        public RouteRegistry getRouteRegistry() {
            return super.getRouteRegistry();
        }
    }

    private static class AlwaysLockedVaadinSession
    extends MockVaadinSession {
        private AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }

    private static class MockVaadinSession
    extends VaadinSession {
        private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
        private int closeCount;
        private ReentrantLock lock = new ReentrantLock();

        private MockVaadinSession(VaadinService service) {
            super(service);
        }

        public void close() {
            super.close();
            ++this.closeCount;
        }

        public int getCloseCount() {
            return this.closeCount;
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public void lock() {
            super.lock();
            referenceKeeper.set(this);
        }

        public void unlock() {
            super.unlock();
            referenceKeeper.remove();
        }
    }
}

