/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.validation;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import elemental.json.Json;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractBasicValidationTest<C extends AbstractField<C, V>, V> {
    protected C testField;

    @Before
    public void setup() {
        this.testField = this.createTestField();
    }

    @Test
    public void webComponentManualValidationEnabled() {
        Assert.assertTrue((boolean)this.testField.getElement().getProperty("manualValidation", false));
    }

    @Test
    public void setRequired_setManualValidation_fireValueChangeEvent_noValidation() {
        this.testField.setRequiredIndicatorVisible(true);
        ((HasValidation)this.testField).setManualValidation(true);
        ComponentUtil.fireEvent(this.testField, (ComponentEvent)new AbstractField.ComponentValueChangeEvent(this.testField, this.testField, this.testField.getEmptyValue(), false));
        Assert.assertFalse((boolean)((HasValidation)this.testField).isInvalid());
    }

    @Test
    public void setRequired_setManualValidation_fireUnparsableChangeEvent_noValidation() {
        this.testField.setRequiredIndicatorVisible(true);
        ((HasValidation)this.testField).setManualValidation(true);
        this.fireUnparsableChangeDomEvent();
        Assert.assertFalse((boolean)((HasValidation)this.testField).isInvalid());
    }

    @Test
    public void setRequired_setManualValidation_fireClientValidatedEvent_noValidation() {
        this.testField.setRequiredIndicatorVisible(true);
        ((HasValidation)this.testField).setManualValidation(true);
        ComponentUtil.fireEvent(this.testField, (ComponentEvent)new HasClientValidation.ClientValidatedEvent(this.testField, false));
        Assert.assertFalse((boolean)((HasValidation)this.testField).isInvalid());
    }

    @Test
    public void setErrorMessage_getErrorMessage() {
        Assert.assertNull((Object)((HasValidation)this.testField).getErrorMessage());
        Assert.assertNull((Object)this.testField.getElement().getProperty("errorMessage"));
        ((HasValidation)this.testField).setErrorMessage("Error");
        Assert.assertEquals((Object)"Error", (Object)((HasValidation)this.testField).getErrorMessage());
        Assert.assertEquals((Object)"Error", (Object)this.testField.getElement().getProperty("errorMessage"));
    }

    @Test
    public void setInvalid_isInvalid() {
        Assert.assertFalse((boolean)((HasValidation)this.testField).isInvalid());
        Assert.assertFalse((boolean)this.testField.getElement().getProperty("invalid", false));
        ((HasValidation)this.testField).setInvalid(true);
        Assert.assertTrue((boolean)((HasValidation)this.testField).isInvalid());
        Assert.assertTrue((boolean)this.testField.getElement().getProperty("invalid", false));
    }

    protected abstract C createTestField();

    private void fireUnparsableChangeDomEvent() {
        DomEvent unparsableChangeDomEvent = new DomEvent(this.testField.getElement(), "unparsable-change", Json.createObject());
        ((ElementListenerMap)this.testField.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(unparsableChangeDomEvent);
    }
}

