/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.validation;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Input;
import com.vaadin.flow.component.html.NativeButton;
import java.io.Serializable;

public abstract class AbstractValidationPage<T extends Component>
extends Div {
    public static final String SERVER_VALIDITY_STATE = "server-validity-state";
    public static final String SERVER_VALIDITY_STATE_BUTTON = "server-validity-state-button";
    protected T testField = this.createTestField();

    protected AbstractValidationPage() {
        this.add(new Component[]{this.testField});
        this.addServerValidityStateControls();
    }

    private void addServerValidityStateControls() {
        Div validityState = new Div();
        validityState.setId(SERVER_VALIDITY_STATE);
        NativeButton validityStateButton = this.createButton(SERVER_VALIDITY_STATE_BUTTON, "Retrieve server validity state", (ComponentEventListener<ClickEvent<NativeButton>>)(ComponentEventListener & Serializable)event -> {
            boolean isValid = !((HasValidation)this.testField).isInvalid();
            validityState.setText(String.valueOf(isValid));
        });
        this.add(new Component[]{new Div(new Component[]{validityState, validityStateButton})});
    }

    protected NativeButton createButton(String id, String title, ComponentEventListener<ClickEvent<NativeButton>> listener) {
        NativeButton button = new NativeButton(title, listener);
        button.setId(id);
        return button;
    }

    protected Input createInput(String id, String placeholder, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Input, String>> listener) {
        Input input = new Input();
        input.setId(id);
        input.setPlaceholder(placeholder);
        input.addValueChangeListener(listener);
        return input;
    }

    protected abstract T createTestField();
}

