/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.validation;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValidation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractBasicValidationTest<C extends AbstractField<C, V>, V> {
    protected C testField;

    @Before
    public void setup() {
        this.testField = this.createTestField();
    }

    @Test
    public void setErrorMessage_getErrorMessage() {
        Assert.assertNull((Object)((HasValidation)this.testField).getErrorMessage());
        Assert.assertNull((Object)this.testField.getElement().getProperty("errorMessage"));
        ((HasValidation)this.testField).setErrorMessage("Error");
        Assert.assertEquals((Object)"Error", (Object)((HasValidation)this.testField).getErrorMessage());
        Assert.assertEquals((Object)"Error", (Object)this.testField.getElement().getProperty("errorMessage"));
    }

    @Test
    public void setInvalid_isInvalid() {
        Assert.assertFalse((boolean)((HasValidation)this.testField).isInvalid());
        Assert.assertFalse((boolean)this.testField.getElement().getProperty("invalid", false));
        ((HasValidation)this.testField).setInvalid(true);
        Assert.assertTrue((boolean)((HasValidation)this.testField).isInvalid());
        Assert.assertTrue((boolean)this.testField.getElement().getProperty("invalid", false));
    }

    protected abstract C createTestField();
}

