/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;

@NpmPackage(value="@vaadin/tooltip", version="25.1.0-alpha8")
@JsModule(value="./tooltip.ts")
public class TooltipConfiguration
implements Serializable {
    private static Integer defaultHideDelay;
    private static Integer defaultFocusDelay;
    private static Integer defaultHoverDelay;
    private static boolean uiInitListenerRegistered;

    public static void setDefaultFocusDelay(int defaultFocusDelay) {
        TooltipConfiguration.defaultFocusDelay = defaultFocusDelay;
        TooltipConfiguration.applyConfiguration();
    }

    public static void setDefaultHideDelay(int defaultHideDelay) {
        TooltipConfiguration.defaultHideDelay = defaultHideDelay;
        TooltipConfiguration.applyConfiguration();
    }

    public static void setDefaultHoverDelay(int defaultHoverDelay) {
        TooltipConfiguration.defaultHoverDelay = defaultHoverDelay;
        TooltipConfiguration.applyConfiguration();
    }

    private static void applyConfiguration() {
        if (UI.getCurrent() != null) {
            TooltipConfiguration.applyConfigurationForUI(UI.getCurrent());
        }
        if (!uiInitListenerRegistered) {
            VaadinService.getCurrent().addUIInitListener((UIInitListener & Serializable)e -> TooltipConfiguration.applyConfigurationForUI(e.getUI()));
            uiInitListenerRegistered = true;
        }
    }

    private static void applyConfigurationForUI(UI ui) {
        ui.getElement().executeJs("((window.Vaadin ||= {}).Flow ||= {}).tooltip ||= {}", new Object[0]);
        if (defaultHideDelay != null) {
            ui.getElement().executeJs("const tooltip = window.Vaadin.Flow.tooltip;tooltip.defaultHideDelay = $0;tooltip.setDefaultHideDelay?.($0)", new Object[]{defaultHideDelay});
        }
        if (defaultFocusDelay != null) {
            ui.getElement().executeJs("const tooltip = window.Vaadin.Flow.tooltip;tooltip.defaultFocusDelay = $0;tooltip.setDefaultFocusDelay?.($0)", new Object[]{defaultFocusDelay});
        }
        if (defaultHoverDelay != null) {
            ui.getElement().executeJs("const tooltip = window.Vaadin.Flow.tooltip;tooltip.defaultHoverDelay = $0;tooltip.setDefaultHoverDelay?.($0)", new Object[]{defaultHoverDelay});
        }
    }

    static {
        uiInitListenerRegistered = false;
    }
}

