/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared.internal;

import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;

public class OverlayClassListProxy
extends AbstractSet<String>
implements ClassList {
    private final HasStyle hasStyle;
    private final ClassList classList;

    public OverlayClassListProxy(HasStyle hasStyle) {
        this.hasStyle = hasStyle;
        this.classList = hasStyle.getElement().getClassList();
    }

    private void updateOverlayClass() {
        this.hasStyle.getElement().setProperty("overlayClass", this.hasStyle.getClassName());
    }

    @Override
    public Iterator<String> iterator() {
        return new IteratorProxy(this.classList.iterator());
    }

    @Override
    public int size() {
        return this.classList.size();
    }

    @Override
    public boolean add(String s) {
        boolean result = this.classList.add((Object)s);
        this.updateOverlayClass();
        return result;
    }

    public void bind(String className, Signal<Boolean> signal) {
        this.classList.bind(className, signal);
    }

    private class IteratorProxy
    implements Serializable,
    Iterator<String> {
        private final Iterator<String> iterator;

        public IteratorProxy(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            OverlayClassListProxy.this.updateOverlayClass();
        }
    }
}

