/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.component.shared.SelectionPreservationMode;
import com.vaadin.flow.data.provider.DataChangeEvent;
import java.io.Serializable;
import java.util.Objects;

public abstract class SelectionPreservationHandler<T>
implements Serializable {
    private SelectionPreservationMode selectionPreservationMode;

    public SelectionPreservationHandler(SelectionPreservationMode selectionPreservationMode) {
        this.setSelectionPreservationMode(selectionPreservationMode);
    }

    public final void setSelectionPreservationMode(SelectionPreservationMode selectionPreservationMode) {
        Objects.requireNonNull(selectionPreservationMode, "Selection preservation mode cannot be null.");
        this.selectionPreservationMode = selectionPreservationMode;
    }

    public final SelectionPreservationMode getSelectionPreservationMode() {
        return this.selectionPreservationMode;
    }

    public final void handleDataChange(DataChangeEvent<T> dataChangeEvent) {
        switch (this.selectionPreservationMode) {
            case PRESERVE_ALL: {
                this.onPreserveAll(dataChangeEvent);
                break;
            }
            case PRESERVE_EXISTING: {
                this.onPreserveExisting(dataChangeEvent);
                break;
            }
            case DISCARD: {
                this.onDiscard(dataChangeEvent);
            }
        }
    }

    public abstract void onPreserveAll(DataChangeEvent<T> var1);

    public abstract void onPreserveExisting(DataChangeEvent<T> var1);

    public abstract void onDiscard(DataChangeEvent<T> var1);
}

