/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.util.stream.Stream;

public interface HasThemeVariant<TVariantEnum extends ThemeVariant>
extends HasTheme {
    default public void addThemeVariants(TVariantEnum ... variants) {
        this.getThemeNames().addAll(Stream.of(variants).map(ThemeVariant::getVariantName).toList());
    }

    default public void removeThemeVariants(TVariantEnum ... variants) {
        this.getThemeNames().removeAll(Stream.of(variants).map(ThemeVariant::getVariantName).toList());
    }

    default public void setThemeVariant(TVariantEnum variant, boolean set) {
        if (set) {
            this.addThemeVariants(new ThemeVariant[]{variant});
        } else {
            this.removeThemeVariants(new ThemeVariant[]{variant});
        }
    }

    default public void setThemeVariants(TVariantEnum ... variants) {
        this.getThemeNames().clear();
        this.addThemeVariants((ThemeVariant[])variants);
    }

    default public void setThemeVariants(boolean set, TVariantEnum ... variants) {
        if (set) {
            this.addThemeVariants((ThemeVariant[])variants);
        } else {
            this.removeThemeVariants((ThemeVariant[])variants);
        }
    }
}

