/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class OverlayAutoAddController<C extends Component>
implements Serializable {
    private final C component;
    private final SerializableSupplier<Boolean> isModalSupplier;
    private boolean skipOnNavigation;
    private boolean autoAdded;
    private Registration beforeLeaveRegistration;

    public OverlayAutoAddController(C component) {
        this(component, (SerializableSupplier<Boolean>)(SerializableSupplier & Serializable)() -> false);
    }

    public OverlayAutoAddController(C component, SerializableSupplier<Boolean> isModalSupplier) {
        this.component = component;
        this.isModalSupplier = isModalSupplier;
        component.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> {
            if (this.isOpened()) {
                this.handleOpen();
            } else {
                this.handleClose();
            }
        });
    }

    public void setSkipOnNavigation(boolean skipOnNavigation) {
        this.skipOnNavigation = skipOnNavigation;
    }

    private void handleOpen() {
        UI ui = this.getUI();
        StateTree.ExecutionRegistration addToUiRegistration = ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
            if (this.isOpened() && !this.isAttached()) {
                if (ui.hasModalComponent()) {
                    this.component.getElement().setAttribute("data-slot-ignore", "");
                }
                ui.addToModalComponent(this.component);
                ui.setChildComponentModal(this.component, ((Boolean)this.isModalSupplier.get()).booleanValue());
                this.autoAdded = true;
            }
            if (this.beforeLeaveRegistration != null) {
                this.beforeLeaveRegistration.remove();
                this.beforeLeaveRegistration = null;
            }
        });
        if (this.skipOnNavigation && ui.getSession() != null) {
            this.beforeLeaveRegistration = ui.addBeforeLeaveListener((BeforeLeaveListener & Serializable)event -> {
                addToUiRegistration.remove();
                this.beforeLeaveRegistration.remove();
                this.beforeLeaveRegistration = null;
            });
        }
    }

    private void handleClose() {
        if (this.autoAdded) {
            this.autoAdded = false;
            this.component.getElement().removeAttribute("data-slot-ignore");
            this.component.getElement().removeFromParent();
        }
    }

    private UI getUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private boolean isOpened() {
        return this.component.getElement().getProperty("opened", false);
    }

    private boolean isAttached() {
        return this.component.getElement().getNode().getParent() != null;
    }
}

