/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.testbench.elements;

import org.openqa.selenium.By;

import com.vaadin.testbench.elementsbase.Element;

/**
 * TestBench element for the legacy Panel component
 */
@Element("div")
public class PanelElement extends AbstractSingleComponentContainer {

    @Override
    public void scroll(int scrollTop) {
        findElement(By.className("v-scrollable")).scroll(scrollTop);
    }

    @Override
    public void scrollLeft(int scrollLeft) {
        findElement(By.className("v-scrollable")).scrollLeft(scrollLeft);
    }

    /**
     * Gets the caption text for the element.
     *
     * @return the label caption
     */
    public String getCaption() {
        return findElement(By.className("v-panel-caption")).getText();
    }
}
