/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.Element;

@Element("div")
public class LabelElement extends AbstractComponentElement {

    /**
     * Gets the caption text for the element.
     *
     * @return the label caption
     */
    public String getCaption() {
        final String gwtIdAttribute = "aria-labelledby";
        String captionId = getAttribute(gwtIdAttribute);
        // element ids are unique, we can search the whole page
        WebElement captElem = getDriver().findElement(By.id(captionId));
        return captElem.getText();
    }

    /**
     * Gets the value of the label.
     *
     * @return the value of the label
     */
    public String getValue() {
        return getText();
    }

}
