/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui.renderers;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.server.ExternalResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.ui.renderers.ClickableRenderer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

public class ImageRenderer
extends ClickableRenderer<Resource> {
    public ImageRenderer() {
        super(Resource.class, null);
    }

    public ImageRenderer(ClickableRenderer.RendererClickListener listener) {
        this();
        this.addClickListener(listener);
    }

    @Override
    protected ComponentRenderer<Component, Item> createClickableWrapperComponentRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            Object value = item.getItemProperty(this.getPropertyId()).getValue();
            if (this.renderer.getConverter() != null) {
                value = this.renderer.getConverter().convertToPresentation(value, new ValueContext((Binder)null));
            }
            if (value != null && !(value instanceof ExternalResource)) {
                throw new IllegalArgumentException("ImageRenderer only supports ExternalResource (" + value.getClass().getSimpleName() + " given)");
            }
            Image image = new Image();
            if (value != null) {
                image.setSrc(((ExternalResource)value).getURL());
            }
            ComponentUtil.addListener((Component)image, ClickableRenderer.RendererClickEvent.class, (ComponentEventListener & Serializable)event -> {
                event.itemId = this.getItemId((Item)item);
                event.column = this.getColumn((String)this.getPropertyId());
                this.clickListeners.forEach(listener -> listener.click((ClickableRenderer.RendererClickEvent)event));
            });
            return image;
        });
    }
}

