/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.event.MouseEvents;
import com.vaadin.featurepack.event.ShortcutListener;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.server.IconResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.shared.MouseEventDetails;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.util.ComponentDataUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.shared.Registration;
import java.util.EventObject;

public class FButton
extends Button
implements FAbstractComponent,
HasSizeable {
    private String iconAltText;
    protected ClickShortcut clickShortcut;

    public FButton() {
    }

    public FButton(String caption) {
        this();
        this.setCaption(caption);
        this.setSizeFull();
        this.setSizeUndefined();
    }

    public FButton(Resource icon) {
        this();
        this.setIconResource(icon);
    }

    public FButton(IconFactory iconFactory) {
        this(iconFactory != null ? new IconResource(iconFactory.create()) : (Resource)null);
    }

    public FButton(String caption, Resource icon) {
        this();
        this.setCaption(caption);
        this.setIconResource(icon);
    }

    public FButton(String caption, IconFactory iconFactory) {
        this(caption, iconFactory != null ? new IconResource(iconFactory.create()) : (Resource)null);
    }

    public FButton(String caption, ClickListener listener) {
        this(caption);
        this.addClickListener(listener);
    }

    public FButton(Resource icon, ClickListener listener) {
        this(icon);
        this.addClickListener(listener);
    }

    public Registration addClickListener(ClickListener listener) {
        return ComponentDataUtil.put("button-clickListeners", (Component)this, listener, ComponentUtil.addListener((Component)this.getFlowComponent(), ClickEvent.class, listener::buttonClick));
    }

    public void removeClickListener(ClickListener listener) {
        ComponentDataUtil.remove("button-clickListeners", (Component)this, listener).map(Registration.class::cast).ifPresent(Registration::remove);
    }

    public void click() {
        if (this.isEnabled()) {
            this.fireClick();
        }
    }

    protected void fireClick() {
        this.fireEvent(new ClickEvent((Component)this));
    }

    protected void fireClick(MouseEventDetails details) {
        this.fireEvent(new ClickEvent((Component)this, details));
    }

    public void setClickShortcut(int keyCode, int ... modifiers) {
        if (this.clickShortcut != null) {
            this.removeShortcutListener(this.clickShortcut);
        }
        this.clickShortcut = new ClickShortcut(this, keyCode, modifiers);
        this.addShortcutListener(this.clickShortcut);
    }

    public void removeClickShortcut() {
        if (this.clickShortcut != null) {
            this.removeShortcutListener(this.clickShortcut);
            this.clickShortcut = null;
        }
    }

    @Override
    public void setCaption(String caption) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-caption", (Object)caption);
        Object labelComponent = this.isCaptionAsHtml() ? new Html("<span>" + (caption == null ? "" : caption) + "</span>") : new Span(this.getCaption());
        labelComponent = this.getIcon() != null ? new Span(new Component[]{this.getFErrorIndicator(), this.getIcon(), labelComponent}) : new Span(new Component[]{this.getFErrorIndicator(), labelComponent});
        labelComponent.addClassName("v-caption");
        this.setLabelComponent((Component)labelComponent);
    }

    public void setIcon(IconFactory iconFactory, String iconAltText) {
        this.setIcon(new IconResource(iconFactory.create()), iconAltText);
    }

    public void setIcon(Resource icon, String iconAltText) {
        this.iconAltText = iconAltText == null ? "" : iconAltText;
        this.setIconResource(icon);
        this.updateIconAltText();
    }

    public String getIconAlternateText() {
        return this.iconAltText;
    }

    public void setIconAlternateText(String iconAltText) {
        this.iconAltText = iconAltText;
        this.setCaption(this.getCaption());
        this.updateIconAltText();
    }

    private void updateIconAltText() {
        if (this.getIcon() != null) {
            this.getIcon().getElement().setAttribute("role", "img");
            this.getIcon().getElement().setAttribute("aria-label", this.iconAltText);
        }
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.setCaptionAsHtml(htmlContentAllowed);
    }

    public boolean isHtmlContentAllowed() {
        return this.isCaptionAsHtml();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        FAbstractComponent.super.setLabelComponent(labelComponent);
        if (labelComponent != null) {
            labelComponent.getElement().getClassList().add((Object)"v-caption");
        }
        this.setPrefixComponent(labelComponent);
    }

    @Override
    public Component getIcon() {
        return FAbstractComponent.super.getIcon();
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    @FunctionalInterface
    public static interface ClickListener
    extends ComponentEventListener<ClickEvent> {
        default public void onComponentEvent(ClickEvent event) {
            this.buttonClick(event);
        }

        public void buttonClick(ClickEvent var1);
    }

    @DomEvent(value="click")
    public static class ClickEvent
    extends MouseEvents.AbstractClickEvent {
        public ClickEvent(Component source, boolean fromClient, @EventData(value="event.clientX") int clientX, @EventData(value="event.clientY") int clientY, @EventData(value="event.detail") int clickCount, @EventData(value="event.button") int button, @EventData(value="event.ctrlKey") boolean ctrlKey, @EventData(value="event.shiftKey") boolean shiftKey, @EventData(value="event.altKey") boolean altKey, @EventData(value="event.metaKey") boolean metaKey, @EventData(value="event.clientX - element.getBoundingClientRect().x") int relativeX, @EventData(value="event.clientY - element.getBoundingClientRect().y") int relativeY) {
            super(source, fromClient, clientX, clientY, clickCount, button, ctrlKey, shiftKey, altKey, metaKey, relativeX, relativeY);
        }

        public ClickEvent(Component source) {
            super(source, null);
        }

        public ClickEvent(Component source, MouseEventDetails details) {
            super(source, details);
        }

        public FButton getFButton() {
            return (FButton)this.getComponent();
        }
    }

    public static class ClickShortcut
    extends ShortcutListener {
        protected FButton button;

        public ClickShortcut(FButton button, String shorthandCaption) {
            super(shorthandCaption);
            this.button = button;
        }

        public ClickShortcut(FButton button, int keyCode, int ... modifiers) {
            super((String)null, keyCode, modifiers);
            this.button = button;
        }

        public ClickShortcut(FButton button, int keyCode) {
            this(button, keyCode, (int[])null);
        }

        @Override
        public void handleAction(Object sender, Object target) {
            this.button.click();
        }
    }
}

