/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.event;

import com.vaadin.featurepack.shared.MouseEventDetails;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;

public interface MouseEvents {

    @FunctionalInterface
    public static interface DoubleClickListener
    extends ComponentEventListener<DoubleClickEvent> {
        default public void onComponentEvent(DoubleClickEvent event) {
            this.doubleClick(event);
        }

        public void doubleClick(DoubleClickEvent var1);
    }

    public static class DoubleClickEvent
    extends ComponentEvent<Component> {
        public DoubleClickEvent(Component source) {
            super(source, true);
        }

        public Component getComponent() {
            return this.getSource();
        }
    }

    @FunctionalInterface
    public static interface ClickListener
    extends ComponentEventListener<ClickEvent> {
        default public void onComponentEvent(ClickEvent event) {
            this.click(event);
        }

        public void click(ClickEvent var1);
    }

    public static abstract class AbstractClickEvent
    extends Event {
        private MouseEventDetails details = new MouseEventDetails();

        public AbstractClickEvent(Component source, boolean fromClient, int clientX, int clientY, int clickCount, int button, boolean ctrlKey, boolean shiftKey, boolean altKey, boolean metaKey, int relativeX, int relativeY) {
            super(source, fromClient);
            this.details.setButton(AbstractClickEvent.getMouseButton(button));
            this.details.setClientX(clientX);
            this.details.setClientY(clientY);
            this.details.setCtrlKey(ctrlKey);
            this.details.setShiftKey(shiftKey);
            this.details.setAltKey(altKey);
            this.details.setMetaKey(metaKey);
            this.details.setRelativeX(relativeX);
            this.details.setRelativeY(relativeY);
            this.details.setType(clickCount == 2 ? 2 : 1);
        }

        public AbstractClickEvent(Component source, MouseEventDetails mouseEventDetails) {
            super(source, false);
            this.details = mouseEventDetails;
        }

        @Override
        public Component getComponent() {
            return this.getSource();
        }

        public MouseEventDetails.MouseButton getButton() {
            return this.details.getButton();
        }

        public int getClientX() {
            return this.details.getClientX();
        }

        public int getClientY() {
            return this.details.getClientY();
        }

        public int getRelativeX() {
            return this.details.getRelativeX();
        }

        public int getRelativeY() {
            return this.details.getRelativeY();
        }

        public boolean isDoubleClick() {
            return this.details.isDoubleClick();
        }

        public boolean isAltKey() {
            return this.details.isAltKey();
        }

        public boolean isCtrlKey() {
            return this.details.isCtrlKey();
        }

        public boolean isMetaKey() {
            return this.details.isMetaKey();
        }

        public boolean isShiftKey() {
            return this.details.isShiftKey();
        }

        public String getButtonName() {
            return this.details.getButtonName();
        }

        private static MouseEventDetails.MouseButton getMouseButton(int button) {
            if (button == 0) {
                return MouseEventDetails.MouseButton.LEFT;
            }
            if (button == 1) {
                return MouseEventDetails.MouseButton.MIDDLE;
            }
            if (button == 2) {
                return MouseEventDetails.MouseButton.RIGHT;
            }
            return null;
        }

        public MouseEventDetails getMouseEventDetails() {
            return this.details;
        }
    }

    @DomEvent(value="mouseup")
    public static class ClickEvent
    extends AbstractClickEvent {
        public ClickEvent(Component source, boolean fromClient, @EventData(value="event.clientX") int clientX, @EventData(value="event.clientY") int clientY, @EventData(value="event.detail") int clickCount, @EventData(value="event.button") int button, @EventData(value="event.ctrlKey") boolean ctrlKey, @EventData(value="event.shiftKey") boolean shiftKey, @EventData(value="event.altKey") boolean altKey, @EventData(value="event.metaKey") boolean metaKey, @EventData(value="event.clientX - element.getBoundingClientRect().x") int relativeX, @EventData(value="event.clientY - element.getBoundingClientRect().y") int relativeY) {
            super(source, fromClient, clientX, clientY, clickCount, button, ctrlKey, shiftKey, altKey, metaKey, relativeX, relativeY);
        }

        public ClickEvent(Component source, MouseEventDetails mouseEventDetails) {
            super(source, mouseEventDetails);
        }
    }
}

