/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.event;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListenerMethod
implements EventListener,
Serializable {
    private final Class<?> eventType;
    private final Object target;
    private transient Method method;
    private Object[] arguments;
    private int eventArgumentIndex;

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.defaultWriteObject();
            String name = this.method.getName();
            Class<?>[] paramTypes = this.method.getParameterTypes();
            out.writeObject(name);
            out.writeObject(paramTypes);
        }
        catch (NotSerializableException e) {
            ListenerMethod.getLogger().log(Level.WARNING, "Error in serialization of the application: Class {0} must implement serialization.", this.target.getClass().getName());
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            String name = (String)in.readObject();
            Class[] paramTypes = (Class[])in.readObject();
            this.method = ListenerMethod.findHighestMethod(this.target.getClass(), name, paramTypes);
        }
        catch (SecurityException e) {
            ListenerMethod.getLogger().log(Level.SEVERE, "Internal deserialization error", e);
        }
    }

    private static Method findHighestMethod(Class<?> cls, String method, Class<?>[] paramTypes) {
        Method parentMethod;
        Class<?>[] ifaces = cls.getInterfaces();
        for (Class<?> clazz : ifaces) {
            Method ifaceMethod = ListenerMethod.findHighestMethod(clazz, method, paramTypes);
            if (ifaceMethod == null) continue;
            return ifaceMethod;
        }
        if (cls.getSuperclass() != null && (parentMethod = ListenerMethod.findHighestMethod(cls.getSuperclass(), method, paramTypes)) != null) {
            return parentMethod;
        }
        for (GenericDeclaration genericDeclaration : cls.getMethods()) {
            if (!((Method)genericDeclaration).getName().equals(method)) continue;
            return genericDeclaration;
        }
        return null;
    }

    public ListenerMethod(Class<?> eventType, Object target, Method method, Object[] arguments, int eventArgumentIndex) throws IllegalArgumentException {
        if (!method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("The method " + method.getName() + " cannot be used for the given target: " + target.getClass().getName());
        }
        if (eventArgumentIndex >= 0 && arguments[eventArgumentIndex] != null) {
            throw new IllegalArgumentException("argument[" + eventArgumentIndex + "] must be null");
        }
        if (eventArgumentIndex >= 0 && !method.getParameterTypes()[eventArgumentIndex].isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("The method " + method.getName() + " does not accept the given eventType: " + eventType.getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.method = method;
        this.arguments = arguments;
        this.eventArgumentIndex = eventArgumentIndex;
    }

    public ListenerMethod(Class<?> eventType, Object target, String methodName, Object[] arguments, int eventArgumentIndex) throws IllegalArgumentException {
        for (Method m : target.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            this.method = m;
            break;
        }
        if (this.method == null) {
            throw new IllegalArgumentException("Method " + methodName + " not found in class " + target.getClass().getName());
        }
        if (eventArgumentIndex >= 0 && arguments[eventArgumentIndex] != null) {
            throw new IllegalArgumentException("argument[" + eventArgumentIndex + "] must be null");
        }
        if (eventArgumentIndex >= 0 && !this.method.getParameterTypes()[eventArgumentIndex].isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " does not accept the given eventType: " + eventType.getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.arguments = arguments;
        this.eventArgumentIndex = eventArgumentIndex;
    }

    public ListenerMethod(Class<?> eventType, Object target, Method method, Object[] arguments) throws IllegalArgumentException {
        if (!method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("The method " + method.getName() + " cannot be used for the given target: " + target.getClass().getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.method = method;
        this.arguments = arguments;
        this.eventArgumentIndex = -1;
    }

    public ListenerMethod(Class<?> eventType, Object target, String methodName, Object[] arguments) throws IllegalArgumentException {
        for (Method m : target.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            this.method = m;
            break;
        }
        if (this.method == null) {
            throw new IllegalArgumentException("Method " + methodName + " not found in class " + target.getClass().getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.arguments = arguments;
        this.eventArgumentIndex = -1;
    }

    public ListenerMethod(Class<?> eventType, Object target, Method method) throws IllegalArgumentException {
        if (!method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("The method " + method.getName() + " cannot be used for the given target: " + target.getClass().getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.method = method;
        this.eventArgumentIndex = -1;
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 0) {
            this.arguments = new Object[0];
        } else if (params.length == 1 && params[0].isAssignableFrom(eventType)) {
            this.arguments = new Object[]{null};
            this.eventArgumentIndex = 0;
        } else {
            throw new IllegalArgumentException("Method requires unknown parameters");
        }
    }

    public ListenerMethod(Class<?> eventType, Object target, String methodName) throws IllegalArgumentException {
        for (Method m : target.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            this.method = m;
            break;
        }
        if (this.method == null) {
            throw new IllegalArgumentException("Method " + methodName + " not found in class " + target.getClass().getName());
        }
        this.eventType = eventType;
        this.target = target;
        this.eventArgumentIndex = -1;
        Class<?>[] params = this.method.getParameterTypes();
        if (params.length == 0) {
            this.arguments = new Object[0];
        } else if (params.length == 1 && params[0].isAssignableFrom(eventType)) {
            this.arguments = new Object[]{null};
            this.eventArgumentIndex = 0;
        } else {
            throw new IllegalArgumentException("Method requires unknown parameters");
        }
    }

    public void receiveEvent(EventObject event) {
        if (this.eventType.isAssignableFrom(event.getClass())) {
            try {
                if (this.eventArgumentIndex >= 0) {
                    if (this.eventArgumentIndex == 0 && this.arguments.length == 1) {
                        this.method.invoke(this.target, event);
                    } else {
                        Object[] arg = new Object[this.arguments.length];
                        System.arraycopy(this.arguments, 0, arg, 0, arg.length);
                        arg[this.eventArgumentIndex] = event;
                        this.method.invoke(this.target, arg);
                    }
                } else {
                    this.method.invoke(this.target, this.arguments);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Internal error - please report", e);
            }
            catch (InvocationTargetException e) {
                throw new MethodException("Invocation of method " + this.method.getName() + " in " + this.target.getClass().getName() + " failed.", e.getTargetException());
            }
        }
    }

    public boolean matches(Class<?> eventType, Object target) {
        return this.target == target && eventType.equals(this.eventType);
    }

    public boolean matches(Class<?> eventType, Object target, Method method) {
        return this.target == target && eventType.equals(this.eventType) && method.equals(this.method);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.eventArgumentIndex;
        hash = 31 * hash + (this.eventType == null ? 0 : this.eventType.hashCode());
        hash = 31 * hash + (this.target == null ? 0 : this.target.hashCode());
        hash = 31 * hash + (this.method == null ? 0 : this.method.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ListenerMethod t = (ListenerMethod)obj;
        return this.eventArgumentIndex == t.eventArgumentIndex && (this.eventType == t.eventType || this.eventType != null && this.eventType.equals(t.eventType)) && (this.target == t.target || this.target != null && this.target.equals(t.target)) && (this.method == t.method || this.method != null && this.method.equals(t.method)) && (this.arguments == t.arguments || Arrays.equals(this.arguments, t.arguments));
    }

    public boolean isType(Class<?> eventType) {
        return this.eventType == eventType;
    }

    public boolean isOrExtendsType(Class<?> eventType) {
        return eventType.isAssignableFrom(this.eventType);
    }

    public Object getTarget() {
        return this.target;
    }

    public Class<?> getEventType() {
        return this.eventType;
    }

    private static final Logger getLogger() {
        return Logger.getLogger(ListenerMethod.class.getName());
    }

    public class MethodException
    extends RuntimeException {
        private MethodException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

