/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.ComponentGeometryUtil;
import com.vaadin.featurepack.desktop.Panel;
import com.vaadin.featurepack.desktop.geometry.Dimension;
import com.vaadin.featurepack.desktop.graphics.LayoutStyle;
import com.vaadin.featurepack.desktop.graphics.VaadinLayoutStyle;
import com.vaadin.featurepack.desktop.layouts.CustomLayout;
import com.vaadin.featurepack.desktop.layouts.GroupLayout;
import com.vaadin.featurepack.desktop.layouts.LayoutManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;

public class GroupLayoutFactory {
    public static GroupLayout newInstance(Component host) {
        GroupLayout gl = new GroupLayout(host);
        gl.setLayoutStyle((LayoutStyle)new VaadinLayoutStyle());
        gl.setComponentGeometryLambdas(ComponentGeometryUtil::getSize, ComponentGeometryUtil::getMaximumSize, ComponentGeometryUtil::getMinimumSize, ComponentGeometryUtil::getPreferredSize, ComponentGeometryUtil::getInsets, ComponentGeometryUtil::setBounds, ComponentGeometryUtil::getBaseline, ComponentGeometryUtil::getBaselineResizeBehavior);
        return gl;
    }

    public static GroupLayout configureLayout(HasComponents parent, Panel panel) {
        if (ComponentGeometryUtil.getMaximumSize(panel) == null) {
            ComponentGeometryUtil.setMaximumSize(panel, new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }
        panel.setLayout(null);
        GroupLayout result = new GroupLayout((Component)panel);
        new CustomLayout((LayoutManager)result).setContainer(panel);
        if (parent != null) {
            parent.add(new Component[]{panel});
        }
        return result;
    }

    public static GroupLayout configureLayout(Panel panel) {
        return GroupLayoutFactory.configureLayout(null, panel);
    }
}

