/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;

public class BoxLayout
extends AbstractLayout {
    private int axis;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String FLEX_START = "flex-start";
    public static final String FLEX_CENTER = "center";
    public static final String FLEX_END = "flex-end";

    public BoxLayout(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Invalid axis");
        }
        this.axis = axis;
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-box-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-box-layout");
            current.getStyle().remove("--vfp-direction");
            current.getStyle().remove("--vfp-justify-content");
            current.getStyle().remove("--vfp-align-items");
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-box-layout", "");
            container.getStyle().set("--vfp-direction", this.axis == 0 ? "row" : "column");
        }
    }

    public int getAxis() {
        return this.axis;
    }

    public void setAlignmentX(String align) {
        if (align != FLEX_START && align != FLEX_CENTER && align != FLEX_END) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        String property = this.axis == 0 ? "--vfp-justify-content" : "--vfp-align-items";
        this.getContainer().getStyle().set(property, align);
    }

    public void setAlignmentY(String align) {
        if (align != FLEX_START && align != FLEX_CENTER && align != FLEX_END) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        String property = this.axis == 0 ? "--vfp-align-items" : "--vfp-justify-content";
        this.getContainer().getStyle().set(property, align);
    }

    public void setConstraints(Component component, Object constraints) {
        throw new UnsupportedOperationException("BoxLayout does not support constraints");
    }

    public Object getConstraints(Component component) {
        throw new UnsupportedOperationException("BoxLayout does not support constraints");
    }
}

