/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.graphics;

import com.vaadin.featurepack.desktop.ComponentGeometryUtil;
import com.vaadin.featurepack.desktop.geometry.Insets;
import com.vaadin.featurepack.desktop.graphics.AbstractVaadinLayoutStyle;
import com.vaadin.featurepack.desktop.graphics.LayoutStyle;
import com.vaadin.flow.component.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class VaadinLayoutStyle
extends AbstractVaadinLayoutStyle {
    private static final VaadinLayoutStyle INSTANCE = new VaadinLayoutStyle();

    public static LayoutStyle getInstance() {
        return INSTANCE;
    }

    protected boolean isLabelAndNonlabel(Component c1, Component c2, int position) {
        if (position == 3 || position == 7) {
            boolean c1Label = c1.getClass().toString().endsWith("Label");
            boolean c2Label = c2.getClass().toString().endsWith("Label");
            return (c1Label || c2Label) && c1Label != c2Label;
        }
        return false;
    }

    protected int getButtonGap(Component source, Component target, int position, int offset) {
        if ((offset -= this.getButtonGap(source, position)) > 0) {
            offset -= this.getButtonGap(target, this.flipDirection(position));
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    protected int getButtonGap(Component source, int position, int offset) {
        return Math.max(offset -= this.getButtonGap(source, position), 0);
    }

    public int getButtonGap(Component c, int position) {
        return 0;
    }

    protected void checkPosition(int position) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException();
        }
    }

    protected int getIndent(Component c, int position) {
        return 0;
    }

    private Icon getIcon(AbstractButton button) {
        return null;
    }

    private boolean isLeftAligned(AbstractButton button, int position) {
        if (position == 7) {
            boolean ltr = button.getComponentOrientation().isLeftToRight();
            int hAlign = button.getHorizontalAlignment();
            return ltr && (hAlign == 2 || hAlign == 10) || !ltr && hAlign == 11;
        }
        return false;
    }

    private boolean isRightAligned(AbstractButton button, int position) {
        if (position == 3) {
            boolean ltr = button.getComponentOrientation().isLeftToRight();
            int hAlign = button.getHorizontalAlignment();
            return ltr && (hAlign == 4 || hAlign == 11) || !ltr && hAlign == 10;
        }
        return false;
    }

    private int getInset(Component c, int position) {
        return this.getInset(ComponentGeometryUtil.getInsets(c), position);
    }

    private int getInset(Insets insets, int position) {
        if (insets == null) {
            return 0;
        }
        switch (position) {
            case 1: {
                return insets.top;
            }
            case 5: {
                return insets.bottom;
            }
            case 3: {
                return insets.right;
            }
            case 7: {
                return insets.left;
            }
        }
        assert (false);
        return 0;
    }
}

