/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.ComponentGeometryUtil;
import com.vaadin.featurepack.desktop.HasLayout;
import com.vaadin.featurepack.desktop.HasLocation;
import com.vaadin.featurepack.desktop.RootContainer;
import com.vaadin.featurepack.desktop.WindowButtonsBar;
import com.vaadin.featurepack.desktop.geometry.Point;
import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.BorderLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Element;
import java.util.Objects;

public class Window
extends Dialog
implements HasLayout,
HasLocation {
    private RootContainer rootContainer;
    private WindowButtonsBar buttons;
    private int locationX;
    private int locationY;

    public Window() {
        this.setRootContainer(new RootContainer());
        this.setLayout(new BorderLayout());
        this.buttons = new WindowButtonsBar(this);
        this.getHeader().add(new Component[]{this.buttons});
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        this.setDraggable(true);
        this.setResizable(true);
        this.setModal(false);
        this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
    }

    public Window(String title) {
        this();
        this.setHeaderTitle(title);
    }

    public void setRootContainer(RootContainer rootContainer) {
        Objects.requireNonNull(rootContainer, "rootContainer must not be null");
        if (this.rootContainer != null) {
            this.getElement().removeChild(new Element[]{this.rootContainer.getElement()});
        }
        this.rootContainer = rootContainer;
        this.getElement().appendChild(new Element[]{this.rootContainer.getElement()});
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public void setMenuBar(Component menuBar) {
        this.rootContainer.setMenuBar(menuBar);
    }

    public Component getMenuBar() {
        return this.rootContainer.getMenuBar();
    }

    public void setContentContainer(Component contentContainer) {
        this.rootContainer.setContentContainer(contentContainer);
    }

    public Component getContentContainer() {
        return this.rootContainer.getContentContainer();
    }

    @Override
    public void setLayout(AbstractLayout layout) {
        ((HasLayout)this.getContentContainer()).setLayout(layout);
    }

    @Override
    public AbstractLayout getLayout() {
        return ((HasLayout)this.getContentContainer()).getLayout();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.close();
        }
    }

    public boolean isVisible() {
        return this.isOpened();
    }

    public void add(Component ... components) {
        ((HasComponents)this.getContentContainer()).add(components);
    }

    public void remove(Component ... components) {
        ((HasComponents)this.getContentContainer()).remove(components);
    }

    public void removeAll() {
        ((HasComponents)this.getContentContainer()).removeAll();
    }

    public boolean isClosable() {
        return this.buttons.isClosable();
    }

    public void setClosable(boolean closable) {
        this.buttons.setClosable(closable);
    }

    public boolean isMinimizable() {
        return this.buttons.isMinimizable();
    }

    public void setMinimizable(boolean minimizable) {
        this.buttons.setMinimizable(minimizable);
    }

    public boolean isMaximizable() {
        return this.buttons.isMaximizable();
    }

    public void setMaximizable(boolean maximizable) {
        this.buttons.setMaximizable(maximizable);
    }

    @Override
    public void setLocation(Point location) {
        this.locationX = location.getX();
        this.locationY = location.getY();
        this.getElement().executeJs("this.$.overlay.setBounds({ top: $0, left: $1 });", new Object[]{ComponentGeometryUtil.formatCSSPixelValue(this.locationY), ComponentGeometryUtil.formatCSSPixelValue(this.locationX)});
    }

    @Override
    public Point getLocation() {
        return new Point(this.locationX, this.locationY);
    }
}

