/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.StyleSheet;

@Tag(value="div")
@StyleSheet(value="context://vfp-scroll-container.css")
public class ScrollContainer
extends AbstractContainer {
    public static final int VERTICAL_SCROLLBAR_AUTO = 20;
    public static final int VERTICAL_SCROLLBAR_HIDDEN = 21;
    public static final int VERTICAL_SCROLLBAR_VISIBLE = 22;
    public static final int HORIZONTAL_SCROLLBAR_AUTO = 30;
    public static final int HORIZONTAL_SCROLLBAR_HIDDEN = 31;
    public static final int HORIZONTAL_SCROLLBAR_VISIBLE = 32;
    protected int verticalScrollbarMode = 20;
    protected int horizontalScrollbarMode = 30;
    private Component view;

    public ScrollContainer() {
        this.getElement().setAttribute("vfp-scroll-container", "");
        this.setVerticalScrollbarMode(this.verticalScrollbarMode);
        this.setHorizontalScrollbarMode(this.horizontalScrollbarMode);
    }

    public ScrollContainer(int verticalScrollbarMode, int horizontalScrollbarMode) {
        this();
        this.setVerticalScrollbarMode(verticalScrollbarMode);
        this.setHorizontalScrollbarMode(horizontalScrollbarMode);
    }

    public ScrollContainer(Component view) {
        this();
        this.setViewportView(view);
    }

    public ScrollContainer(Component view, int verticalScrollbarMode, int horizontalScrollbarMode) {
        this(verticalScrollbarMode, horizontalScrollbarMode);
        this.setViewportView(view);
    }

    public void setViewportView(Component view) {
        if (this.view != null) {
            this.remove(this.view);
        }
        this.view = view;
        if (view != null) {
            this.add(view);
        }
    }

    public Component getViewportView() {
        return this.view;
    }

    public void setVerticalScrollbarMode(int mode) {
        this.verticalScrollbarMode = mode;
        this.getStyle().set("--vfp-overflow-y", this.getCSSOverflow(mode));
    }

    public int getVerticalScrollbarMode() {
        return this.verticalScrollbarMode;
    }

    public void setHorizontalScrollbarMode(int mode) {
        this.horizontalScrollbarMode = mode;
        this.getStyle().set("--vfp-overflow-x", this.getCSSOverflow(mode));
    }

    public int getHorizontalScrollbarMode() {
        return this.horizontalScrollbarMode;
    }

    private String getCSSOverflow(int scrollBarMode) {
        return switch (scrollBarMode) {
            case 20, 30 -> "auto";
            case 21, 31 -> "hidden";
            case 22, 32 -> "scroll";
            default -> throw new IllegalArgumentException("Invalid scrollbar mode: " + scrollBarMode);
        };
    }
}

