/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;

public class NotificationUtils {
    public static void show(String text) {
        Notification.show((String)text);
    }

    public static void show(String title, String message) {
        NotificationUtils.show(title, message, null);
    }

    public static void showError(String title, String message) {
        NotificationUtils.show(title, message, NotificationVariant.LUMO_ERROR);
    }

    public static void showInformation(String title, String message) {
        NotificationUtils.show(title, message, NotificationVariant.LUMO_PRIMARY);
    }

    public static void showWarning(String title, String message) {
        NotificationUtils.show(title, message, NotificationVariant.LUMO_WARNING);
    }

    public static void showQuestion(String title, String message) {
        NotificationUtils.show(title, message, NotificationVariant.LUMO_CONTRAST);
    }

    public static void show(String title, String message, NotificationVariant variant) {
        Span titleSpan = new Span(title);
        titleSpan.getStyle().set("font-weight", "bold");
        Span messageSpan = new Span(message);
        VerticalLayout content = new VerticalLayout(new Component[]{titleSpan, messageSpan});
        Notification notification = new Notification(new Component[]{content});
        notification.setDuration(5000);
        if (variant != null) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{variant});
        }
        notification.open();
    }
}

