/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.AbstractFLabel;
import com.vaadin.featurepack.desktop.ComponentGeometryUtil;
import com.vaadin.featurepack.desktop.geometry.Dimension;
import com.vaadin.featurepack.desktop.graphics.Color;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Image;

public class FLabel
extends AbstractFLabel {
    Image iconImage;

    public FLabel(String s) {
        super(s);
        ComponentGeometryUtil.setMinimumSize((Component)this, new Dimension(50, 30));
        ComponentGeometryUtil.setPreferredSize((Component)this, new Dimension(250, 30));
        ComponentGeometryUtil.setMaximumSize((Component)this, new Dimension(250, 30));
    }

    public FLabel() {
        ComponentGeometryUtil.setMinimumSize((Component)this, new Dimension(50, 30));
        ComponentGeometryUtil.setPreferredSize((Component)this, new Dimension(250, 30));
        ComponentGeometryUtil.setMaximumSize((Component)this, new Dimension(250, 30));
    }

    public void setIcon(Image icon) {
        if (this.iconImage != null) {
            try {
                this.remove(new Component[]{this.iconImage});
            }
            catch (Exception e) {
                System.out.println("iconImage is not child: " + String.valueOf(this.iconImage));
            }
        }
        if (icon == null) {
            return;
        }
        this.iconImage = new Image(icon.getSrc(), (String)icon.getAlt().orElse(null));
        this.addComponentAsFirst((Component)this.iconImage);
    }

    public Image getIcon() {
        return this.iconImage;
    }

    public void setForeground(Color c) {
        String oldVal = this.getStyle().get("color");
        String newVal = c.toHexString();
        this.getStyle().set("color", newVal);
    }

    public void setBackground(Color c) {
        String oldVal = this.getStyle().get("background-color");
        String newVal = c.toHexString();
        this.getStyle().set("background-color", newVal);
    }

    public void setText(String text) {
        super.setText(text);
        int size = 15 + text.toCharArray().length * 10;
        ComponentGeometryUtil.setMinimumSize((Component)this, new Dimension(size, 30));
        ComponentGeometryUtil.setPreferredSize((Component)this, new Dimension(size, 30));
        ComponentGeometryUtil.setMaximumSize((Component)this, new Dimension(size, 30));
        ComponentGeometryUtil.setSize((Component)this, new Dimension(size, 30));
    }
}

