/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.featurepack.desktop.HasLocation;
import com.vaadin.featurepack.desktop.geometry.Dimension;
import com.vaadin.featurepack.desktop.geometry.Insets;
import com.vaadin.featurepack.desktop.geometry.Point;
import com.vaadin.featurepack.desktop.geometry.Rectangle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import java.awt.Component;
import java.io.Serializable;

public class ComponentGeometryUtil
implements Serializable {
    private ComponentGeometryUtil() {
    }

    public static void setSize(Component component, Dimension size) {
        ((HasSize)component).setWidth(ComponentGeometryUtil.formatCSSPixelValue(size.getWidth()));
        ((HasSize)component).setHeight(ComponentGeometryUtil.formatCSSPixelValue(size.getHeight()));
    }

    public static void setSize(Component component, int width, int height) {
        ComponentGeometryUtil.setSize(component, new Dimension(width, height));
    }

    public static Dimension getSize(Component component) {
        Dimension result = new Dimension(ComponentGeometryUtil.parseCSSPixelValue(((HasSize)component).getWidth()), ComponentGeometryUtil.parseCSSPixelValue(((HasSize)component).getHeight()));
        return result;
    }

    public static void setMinimumSize(Component component, Dimension size) {
        ((HasSize)component).setMinWidth(ComponentGeometryUtil.formatCSSPixelValue(size.getWidth()));
        ((HasSize)component).setMinHeight(ComponentGeometryUtil.formatCSSPixelValue(size.getHeight()));
    }

    public static Dimension getMinimumSize(Component component) {
        String minWidth = ((HasSize)component).getMinWidth();
        String minHeigh = ((HasSize)component).getMinHeight();
        Dimension result = null;
        if (minWidth != null && minHeigh != null) {
            result = new Dimension(ComponentGeometryUtil.parseCSSPixelValue(minWidth), ComponentGeometryUtil.parseCSSPixelValue(minHeigh));
        }
        return result;
    }

    public static void setMaximumSize(Component component, Dimension size) {
        if (size == null) {
            ((HasSize)component).setSizeFull();
        } else {
            ((HasSize)component).setMaxWidth(ComponentGeometryUtil.formatCSSPixelValue(size.getWidth()));
            ((HasSize)component).setMaxHeight(ComponentGeometryUtil.formatCSSPixelValue(size.getHeight()));
        }
    }

    public static Dimension getMaximumSize(Component component) {
        String maxWidth = ((HasSize)component).getMaxWidth();
        String maxHeigh = ((HasSize)component).getMaxHeight();
        Dimension result = null;
        if (maxWidth != null && maxHeigh != null) {
            result = new Dimension(ComponentGeometryUtil.parseCSSPixelValue(((HasSize)component).getMaxWidth()), ComponentGeometryUtil.parseCSSPixelValue(((HasSize)component).getMaxHeight()));
        }
        return result;
    }

    public static void setPreferredSize(Component component, Dimension size) {
        if (size != null) {
            component.getElement().setAttribute("has-preferred-size", "");
            component.getStyle().set("--vfp-preferred-width", ComponentGeometryUtil.formatCSSPixelValue(size.getWidth()));
            component.getStyle().set("--vfp-preferred-height", ComponentGeometryUtil.formatCSSPixelValue(size.getHeight()));
        } else {
            component.getElement().removeAttribute("has-preferred-size");
            component.getStyle().remove("--vfp-preferred-width");
            component.getStyle().remove("--vfp-preferred-height");
        }
    }

    public static void resetToPreferredSizes(Component component) {
    }

    public static Dimension getPreferredSize(Component component) {
        Dimension result = null;
        if (component.getElement().hasAttribute("has-preferred-size")) {
            result = new Dimension(ComponentGeometryUtil.parseCSSPixelValue(component.getStyle().get("--vfp-preferred-width")), ComponentGeometryUtil.parseCSSPixelValue(component.getStyle().get("--vfp-preferred-height")));
        }
        return result;
    }

    public static void setLocation(Component component, Point location) {
        if (component instanceof HasLocation) {
            ((HasLocation)component).setLocation(location);
            return;
        }
        component.getStyle().set("left", ComponentGeometryUtil.formatCSSPixelValue(location.getX()));
        component.getStyle().set("top", ComponentGeometryUtil.formatCSSPixelValue(location.getY()));
    }

    public static void setLocation(Component component, int x, int y) {
        ComponentGeometryUtil.setLocation(component, new Point(x, y));
    }

    public static Point getLocation(Component component) {
        if (component instanceof HasLocation) {
            return ((HasLocation)component).getLocation();
        }
        return new Point(ComponentGeometryUtil.parseCSSPixelValue(component.getElement().getStyle().get("left")), ComponentGeometryUtil.parseCSSPixelValue(component.getElement().getStyle().get("top")));
    }

    public static void setBounds(Component component, Rectangle bounds) {
        ComponentGeometryUtil.setSize(component, bounds.getSize());
        ComponentGeometryUtil.setLocation(component, bounds.getLocation());
    }

    public static void setBounds(Component component, int x, int y, int width, int height) {
        ComponentGeometryUtil.setSize(component, new Dimension(width, height));
        ComponentGeometryUtil.setLocation(component, new Point(x, y));
    }

    public static Rectangle getBounds(Component component) {
        return new Rectangle(ComponentGeometryUtil.getLocation(component), ComponentGeometryUtil.getSize(component));
    }

    public static String formatCSSPixelValue(int value) {
        return value + "px";
    }

    public static int parseCSSPixelValue(String value) {
        return Integer.parseInt(value.replaceAll("px", ""));
    }

    public static int getBaseline(Component component, int width, int height) {
        return -1;
    }

    public static int getBaseline(Component component, Dimension dimension) {
        return -1;
    }

    public static Component.BaselineResizeBehavior getBaselineResizeBehavior(Component component) {
        throw new RuntimeException("TODO");
    }

    public static Insets getInsets(Component component) {
        if (component instanceof AbstractContainer) {
            return ((AbstractContainer)component).getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }
}

