/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.BoxLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;

@Tag(value="div")
public class Box
extends AbstractContainer {
    public Box(int axis) {
        this.setLayout(new BoxLayout(axis));
    }

    public Box(BoxLayout layout) {
        this.setLayout(layout);
    }

    @Override
    public BoxLayout getLayout() {
        return (BoxLayout)super.getLayout();
    }

    public static Component createHorizontalStrut(int width) {
        Div strut = new Div();
        strut.getElement().setAttribute("vfp-box-layout-horizontal-strut", "");
        strut.getStyle().set("--vfp-strut-size", width + "px");
        return strut;
    }

    public static Component createVerticalStrut(int height) {
        Div strut = new Div();
        strut.getElement().setAttribute("vfp-box-layout-vertical-strut", "");
        strut.getStyle().set("--vfp-strut-size", height + "px");
        return strut;
    }

    public static Component createGlue() {
        Div glue = new Div();
        glue.getElement().setAttribute("vfp-box-layout-glue", "");
        return glue;
    }

    @Override
    public void setLayout(AbstractLayout layout) {
        if (layout instanceof BoxLayout) {
            super.setLayout(layout);
            return;
        }
        throw new IllegalArgumentException("Box can only use a BoxLayout");
    }

    public static Box createHorizontalBox() {
        BoxLayout layout = new BoxLayout(0);
        Box b = new Box(layout);
        return b;
    }

    public static Box createVerticalBox() {
        BoxLayout layout = new BoxLayout(1);
        Box b = new Box(layout);
        return b;
    }
}

