/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.HasLayout;
import com.vaadin.featurepack.desktop.geometry.Insets;
import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.server.Helpers;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.UsageStatistics;
import java.util.Arrays;
import java.util.stream.Stream;

@StyleSheet(value="context://vfp-container.css")
public abstract class AbstractContainer
extends Component
implements HasLayout,
HasComponents,
HasSize,
Focusable {
    private static final String PROJECT_NAME = "vaadin-feature-pack";
    private static final String PROJECT_VERSION_PROP = "feature-pack.version";
    private AbstractLayout layout;

    public AbstractContainer() {
        this.getElement().setAttribute("vfp-container", "");
    }

    @Override
    public void setLayout(AbstractLayout layout) {
        if (this.layout != null) {
            this.layout.setContainer(null);
        }
        this.layout = layout;
        if (layout != null) {
            layout.setContainer((Component)this);
            this.getElement().setAttribute("has-layout", "");
        } else {
            this.getElement().removeAttribute("has-layout");
        }
    }

    @Override
    public AbstractLayout getLayout() {
        return this.layout;
    }

    public void add(Component ... components) {
        super.add(components);
        if (this.layout != null) {
            Arrays.asList(components).forEach(component -> this.layout.addComponent(component));
        }
    }

    public void remove(Component ... components) {
        super.remove(components);
        if (this.layout != null) {
            Arrays.asList(components).forEach(component -> this.layout.removeComponent(component));
        }
    }

    public void removeAll() {
        Stream children = this.getChildren();
        super.removeAll();
        if (this.layout != null) {
            children.forEach(component -> this.layout.removeComponent(component));
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public int getComponentCount() {
        int count = this.getElement().getChildCount();
        return count;
    }

    public Component getComponent(int i) {
        Element elementAt = this.getElement().getChild(i);
        return (Component)elementAt.getComponent().get();
    }

    static {
        String projectVersion = Helpers.getProperty(PROJECT_VERSION_PROP);
        Helpers.checkLicense(PROJECT_NAME, projectVersion);
        UsageStatistics.markAsUsed((String)PROJECT_NAME, (String)projectVersion);
    }
}

