/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.validator;

import com.vaadin.featurepack.data.Validator;

public abstract class AbstractValidator<T>
implements Validator {
    private String errorMessage;

    public AbstractValidator(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isValid(Object value) {
        try {
            this.validate(value);
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    protected abstract boolean isValidValue(T var1);

    @Override
    public void validate(Object value) throws Validator.InvalidValueException {
        if (!this.isValidType(value) || !this.isValidValue(value)) {
            String message = this.getErrorMessage().replace("{0}", String.valueOf(value));
            throw new Validator.InvalidValueException(message);
        }
    }

    protected boolean isValidType(Object value) {
        if (value == null) {
            return true;
        }
        return this.getType().isAssignableFrom(value.getClass());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public abstract Class<T> getType();
}

