/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.util.AbstractContainer;
import com.vaadin.featurepack.data.util.AbstractInMemoryContainer;
import com.vaadin.featurepack.data.util.ItemSorter;
import com.vaadin.featurepack.data.util.ListSet;
import com.vaadin.featurepack.data.util.filter.SimpleStringFilter;
import com.vaadin.featurepack.data.util.filter.UnsupportedFilterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class IndexedContainer
extends AbstractInMemoryContainer<Object, Object, Item>
implements Container.PropertySetChangeNotifier,
Property.ValueChangeNotifier,
Container.Sortable,
Cloneable,
Container.Filterable,
Container.SimpleFilterable {
    private ArrayList<Object> propertyIds = new ArrayList();
    private Hashtable<Object, Class<?>> types = new Hashtable();
    private Hashtable<Object, Map<Object, Object>> items = new Hashtable();
    private HashSet<Property<?>> readOnlyProperties = new HashSet();
    private LinkedList<Property.ValueChangeListener> propertyValueChangeListeners = null;
    private Hashtable<Object, Map<Object, List<Property.ValueChangeListener>>> singlePropertyValueChangeListeners = null;
    private HashMap<Object, Object> defaultPropertyValues;
    private int nextGeneratedItemId = 1;

    public IndexedContainer() {
    }

    public IndexedContainer(Collection<?> itemIds) {
        this();
        if (this.items != null) {
            for (Object itemId : itemIds) {
                this.internalAddItemAtEnd(itemId, new IndexedContainerItem(itemId), false);
            }
            this.filterAll();
        }
    }

    @Override
    protected Item getUnfilteredItem(Object itemId) {
        if (itemId != null && this.items.containsKey(itemId)) {
            return new IndexedContainerItem(itemId);
        }
        return null;
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return Collections.unmodifiableCollection(this.propertyIds);
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.types.get(propertyId);
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        if (!this.containsId(itemId) || propertyId == null || !this.types.containsKey(propertyId)) {
            return null;
        }
        return new IndexedContainerProperty(itemId, propertyId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) {
        if (propertyId == null || type == null) {
            return false;
        }
        if (this.propertyIds.contains(propertyId)) {
            return false;
        }
        this.propertyIds.add(propertyId);
        this.types.put(propertyId, type);
        if (defaultValue != null) {
            Iterator i = this.getAllItemIds().iterator();
            while (i.hasNext()) {
                this.getItem(i.next()).getItemProperty(propertyId).setValue(defaultValue);
            }
            if (this.defaultPropertyValues == null) {
                this.defaultPropertyValues = new HashMap();
            }
            this.defaultPropertyValues.put(propertyId, defaultValue);
        }
        this.fireContainerPropertySetChange();
        return true;
    }

    @Override
    public boolean removeAllItems() {
        int origSize = this.size();
        Object firstItem = this.getFirstVisibleItem();
        this.internalRemoveAllItems();
        this.items.clear();
        if (origSize != 0) {
            this.fireItemsRemoved(0, firstItem, origSize);
        }
        return true;
    }

    @Override
    public Object addItem() {
        Serializable id = this.generateId();
        this.addItem(id);
        return id;
    }

    @Override
    public Item addItem(Object itemId) {
        IndexedContainerItem item = this.internalAddItemAtEnd(itemId, new IndexedContainerItem(itemId), false);
        if (item == null) {
            return null;
        }
        if (!this.isFiltered()) {
            this.fireItemAdded(this.size() - 1, itemId, item);
        } else if (this.passesFilters(itemId) && !this.containsId(itemId)) {
            this.getFilteredItemIds().add(itemId);
            this.fireItemAdded(this.size() - 1, itemId, item);
        }
        return item;
    }

    private void addDefaultValues(Hashtable<Object, Object> t) {
        if (this.defaultPropertyValues != null) {
            for (Object key : this.defaultPropertyValues.keySet()) {
                t.put(key, this.defaultPropertyValues.get(key));
            }
        }
    }

    @Override
    public boolean removeItem(Object itemId) {
        if (itemId == null || this.items.remove(itemId) == null) {
            return false;
        }
        int origSize = this.size();
        int position = this.indexOfId(itemId);
        if (this.internalRemoveItem(itemId)) {
            if (this.size() != origSize) {
                this.fireItemRemoved(position, itemId);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) {
        if (!this.propertyIds.contains(propertyId)) {
            return false;
        }
        this.propertyIds.remove(propertyId);
        this.types.remove(propertyId);
        if (this.defaultPropertyValues != null) {
            this.defaultPropertyValues.remove(propertyId);
        }
        Iterator i = this.getAllItemIds().iterator();
        while (i.hasNext()) {
            this.items.get(i.next()).remove(propertyId);
        }
        this.fireContainerPropertySetChange();
        return true;
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) {
        return this.internalAddItemAfter(previousItemId, newItemId, new IndexedContainerItem(newItemId), true);
    }

    @Override
    public Object addItemAfter(Object previousItemId) {
        Serializable id = this.generateId();
        if (this.addItemAfter(previousItemId, id) != null) {
            return id;
        }
        return null;
    }

    @Override
    public Item addItemAt(int index, Object newItemId) {
        return this.internalAddItemAt(index, newItemId, new IndexedContainerItem(newItemId), true);
    }

    @Override
    public Object addItemAt(int index) {
        Serializable id = this.generateId();
        this.addItemAt(index, id);
        return id;
    }

    private Serializable generateId() {
        Integer id;
        while (this.items.containsKey(id = Integer.valueOf(this.nextGeneratedItemId++))) {
        }
        return id;
    }

    @Override
    protected void registerNewItem(int index, Object newItemId, Item item) {
        Hashtable<Object, Object> t = new Hashtable<Object, Object>();
        this.items.put(newItemId, t);
        this.addDefaultValues(t);
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.addPropertySetChangeListener(listener);
    }

    @Override
    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.removePropertySetChangeListener(listener);
    }

    @Override
    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        if (this.propertyValueChangeListeners == null) {
            this.propertyValueChangeListeners = new LinkedList();
        }
        this.propertyValueChangeListeners.add(listener);
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        if (this.propertyValueChangeListeners != null) {
            this.propertyValueChangeListeners.remove(listener);
        }
    }

    private void firePropertyValueChange(IndexedContainerProperty source) {
        List<Property.ValueChangeListener> listenerList;
        Map<Object, List<Property.ValueChangeListener>> propertySetToListenerListMap;
        if (this.propertyValueChangeListeners != null) {
            Object[] l = this.propertyValueChangeListeners.toArray();
            PropertyValueChangeEvent event = new PropertyValueChangeEvent(source);
            for (int i = 0; i < l.length; ++i) {
                ((Property.ValueChangeListener)l[i]).valueChange(event);
            }
        }
        if (this.singlePropertyValueChangeListeners != null && (propertySetToListenerListMap = this.singlePropertyValueChangeListeners.get(source.propertyId)) != null && (listenerList = propertySetToListenerListMap.get(source.itemId)) != null) {
            PropertyValueChangeEvent event = new PropertyValueChangeEvent(source);
            Object[] listeners = listenerList.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((Property.ValueChangeListener)listeners[i]).valueChange(event);
            }
        }
    }

    @Override
    public Collection<?> getListeners(Class<?> eventType) {
        if (Property.ValueChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.propertyValueChangeListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.propertyValueChangeListeners);
        }
        return super.getListeners(eventType);
    }

    @Override
    protected void fireItemAdded(int position, Object itemId, Item item) {
        if (position >= 0) {
            super.fireItemAdded(position, itemId, item);
        }
    }

    @Override
    protected void fireItemSetChange() {
        this.fireItemSetChange(new ItemSetChangeEvent(this, -1));
    }

    private void addSinglePropertyChangeListener(Object propertyId, Object itemId, Property.ValueChangeListener listener) {
        if (listener != null) {
            List<Property.ValueChangeListener> listenerList;
            Map<Object, List<Property.ValueChangeListener>> propertySetToListenerListMap;
            if (this.singlePropertyValueChangeListeners == null) {
                this.singlePropertyValueChangeListeners = new Hashtable();
            }
            if ((propertySetToListenerListMap = this.singlePropertyValueChangeListeners.get(propertyId)) == null) {
                propertySetToListenerListMap = new Hashtable<Object, List<Property.ValueChangeListener>>();
                this.singlePropertyValueChangeListeners.put(propertyId, propertySetToListenerListMap);
            }
            if ((listenerList = propertySetToListenerListMap.get(itemId)) == null) {
                listenerList = new LinkedList<Property.ValueChangeListener>();
                propertySetToListenerListMap.put(itemId, listenerList);
            }
            listenerList.add(listener);
        }
    }

    private void removeSinglePropertyChangeListener(Object propertyId, Object itemId, Property.ValueChangeListener listener) {
        if (listener != null && this.singlePropertyValueChangeListeners != null) {
            Map<Object, List<Property.ValueChangeListener>> propertySetToListenerListMap = this.singlePropertyValueChangeListeners.get(propertyId);
            if (propertySetToListenerListMap != null) {
                List<Property.ValueChangeListener> listenerList = propertySetToListenerListMap.get(itemId);
                if (listenerList != null) {
                    listenerList.remove(listener);
                    if (listenerList.isEmpty()) {
                        propertySetToListenerListMap.remove(itemId);
                    }
                }
                if (propertySetToListenerListMap.isEmpty()) {
                    this.singlePropertyValueChangeListeners.remove(propertyId);
                }
            }
            if (this.singlePropertyValueChangeListeners.isEmpty()) {
                this.singlePropertyValueChangeListeners = null;
            }
        }
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) {
        this.sortContainer(propertyId, ascending);
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        return this.getSortablePropertyIds();
    }

    @Override
    public ItemSorter getItemSorter() {
        return super.getItemSorter();
    }

    @Override
    public void setItemSorter(ItemSorter itemSorter) {
        super.setItemSorter(itemSorter);
    }

    @Deprecated
    public Object clone() throws CloneNotSupportedException {
        IndexedContainer nc = new IndexedContainer();
        nc.setAllItemIds(this.getAllItemIds() != null ? (ListSet)((ListSet)this.getAllItemIds()).clone() : null);
        nc.setItemSetChangeListeners((Collection<Container.ItemSetChangeListener>)(this.getItemSetChangeListeners() != null ? new LinkedList<Container.ItemSetChangeListener>(this.getItemSetChangeListeners()) : null));
        nc.propertyIds = this.propertyIds != null ? (ArrayList)this.propertyIds.clone() : null;
        nc.setPropertySetChangeListeners((Collection<Container.PropertySetChangeListener>)(this.getPropertySetChangeListeners() != null ? new LinkedList<Container.PropertySetChangeListener>(this.getPropertySetChangeListeners()) : null));
        nc.propertyValueChangeListeners = this.propertyValueChangeListeners != null ? (LinkedList)this.propertyValueChangeListeners.clone() : null;
        nc.readOnlyProperties = this.readOnlyProperties != null ? (HashSet)this.readOnlyProperties.clone() : null;
        nc.singlePropertyValueChangeListeners = this.singlePropertyValueChangeListeners != null ? (Hashtable)this.singlePropertyValueChangeListeners.clone() : null;
        nc.types = this.types != null ? (Hashtable)this.types.clone() : null;
        nc.setFilters((HashSet)((HashSet)this.getFilters()).clone());
        nc.setFilteredItemIds(this.getFilteredItemIds() == null ? null : (ListSet)((ListSet)this.getFilteredItemIds()).clone());
        if (this.items == null) {
            nc.items = null;
        } else {
            nc.items = new Hashtable();
            for (Object id : this.items.keySet()) {
                Hashtable it = (Hashtable)this.items.get(id);
                nc.items.put(id, (Map)it.clone());
            }
        }
        return nc;
    }

    @Override
    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        try {
            this.addFilter(new SimpleStringFilter(propertyId, filterString, ignoreCase, onlyMatchPrefix));
        }
        catch (UnsupportedFilterException unsupportedFilterException) {
            // empty catch block
        }
    }

    @Override
    public void removeAllContainerFilters() {
        this.removeAllFilters();
    }

    @Override
    public void removeContainerFilters(Object propertyId) {
        this.removeFilters(propertyId);
    }

    @Override
    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.addFilter(filter);
    }

    @Override
    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(filter);
    }

    @Override
    public boolean hasContainerFilters() {
        return super.hasContainerFilters();
    }

    @Override
    public Collection<Container.Filter> getContainerFilters() {
        return super.getContainerFilters();
    }

    class IndexedContainerItem
    implements Item {
        private final Object itemId;

        private IndexedContainerItem(Object itemId) {
            this.itemId = itemId;
        }

        @Override
        public Property getItemProperty(Object id) {
            if (!IndexedContainer.this.propertyIds.contains(id)) {
                return null;
            }
            return new IndexedContainerProperty(this.itemId, id);
        }

        @Override
        public Collection<?> getItemPropertyIds() {
            return Collections.unmodifiableCollection(IndexedContainer.this.propertyIds);
        }

        public String toString() {
            Object retValue = "";
            Iterator<Object> i = IndexedContainer.this.propertyIds.iterator();
            while (i.hasNext()) {
                Object propertyId = i.next();
                retValue = (String)retValue + String.valueOf(this.getItemProperty(propertyId).getValue());
                if (!i.hasNext()) continue;
                retValue = (String)retValue + " ";
            }
            return retValue;
        }

        public int hashCode() {
            return this.itemId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(IndexedContainerItem.class)) {
                return false;
            }
            IndexedContainerItem li = (IndexedContainerItem)obj;
            return this.getHost() == li.getHost() && this.itemId.equals(li.itemId);
        }

        private IndexedContainer getHost() {
            return IndexedContainer.this;
        }

        @Override
        public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Indexed container item does not support adding new properties");
        }

        @Override
        public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Indexed container item does not support property removal");
        }
    }

    private class IndexedContainerProperty<T>
    implements Property<T>,
    Property.ValueChangeNotifier {
        private final Object itemId;
        private final Object propertyId;

        private IndexedContainerProperty(Object itemId, Object propertyId) {
            if (itemId == null || propertyId == null) {
                throw new NullPointerException("Container item or property ids can not be null");
            }
            this.propertyId = propertyId;
            this.itemId = itemId;
        }

        @Override
        public Class<T> getType() {
            return IndexedContainer.this.types.get(this.propertyId);
        }

        @Override
        public T getValue() {
            return Optional.ofNullable(IndexedContainer.this.items.get(this.itemId)).map(item -> item.get(this.propertyId)).orElse(null);
        }

        @Override
        public boolean isPropertyReadOnly() {
            return IndexedContainer.this.readOnlyProperties.contains(this);
        }

        @Override
        public void setPropertyReadOnly(boolean newStatus) {
            if (newStatus) {
                IndexedContainer.this.readOnlyProperties.add(this);
            } else {
                IndexedContainer.this.readOnlyProperties.remove(this);
            }
        }

        @Override
        public void setValue(Object newValue) throws Property.ReadOnlyException {
            Map<Object, Object> propertySet = IndexedContainer.this.items.get(this.itemId);
            if (newValue == null) {
                propertySet.remove(this.propertyId);
            } else if (this.getType().isAssignableFrom(newValue.getClass())) {
                propertySet.put(this.propertyId, newValue);
            } else {
                throw new IllegalArgumentException("Value is of invalid type, got " + newValue.getClass().getName() + " but " + this.getType().getName() + " was expected");
            }
            if (IndexedContainer.this.isPropertyFiltered(this.propertyId)) {
                IndexedContainer.this.filterAll();
            }
            IndexedContainer.this.firePropertyValueChange(this);
        }

        private Logger getLogger() {
            return Logger.getLogger(IndexedContainerProperty.class.getName());
        }

        public int hashCode() {
            return this.itemId.hashCode() ^ this.propertyId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(IndexedContainerProperty.class)) {
                return false;
            }
            IndexedContainerProperty lp = (IndexedContainerProperty)obj;
            return lp.getHost() == this.getHost() && lp.propertyId.equals(this.propertyId) && lp.itemId.equals(this.itemId);
        }

        @Override
        public void addValueChangeListener(Property.ValueChangeListener listener) {
            IndexedContainer.this.addSinglePropertyChangeListener(this.propertyId, this.itemId, listener);
        }

        @Override
        public void removeValueChangeListener(Property.ValueChangeListener listener) {
            IndexedContainer.this.removeSinglePropertyChangeListener(this.propertyId, this.itemId, listener);
        }

        private IndexedContainer getHost() {
            return IndexedContainer.this;
        }
    }

    private static class PropertyValueChangeEvent
    extends EventObject
    implements Property.ValueChangeEvent,
    Serializable {
        private PropertyValueChangeEvent(Property source) {
            super(source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }

    public static class ItemSetChangeEvent
    extends AbstractContainer.BaseItemSetChangeEvent {
        private final int addedItemIndex;

        private ItemSetChangeEvent(IndexedContainer source, int addedItemIndex) {
            super(source);
            this.addedItemIndex = addedItemIndex;
        }

        public int getAddedItemIndex() {
            return this.addedItemIndex;
        }
    }
}

