/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import com.vaadin.featurepack.data.Container;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;

public abstract class AbstractContainer
implements Container {
    private Collection<Container.PropertySetChangeListener> propertySetChangeListeners = null;
    private Collection<Container.ItemSetChangeListener> itemSetChangeListeners = null;

    protected void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.getPropertySetChangeListeners() == null) {
            this.setPropertySetChangeListeners(new LinkedList<Container.PropertySetChangeListener>());
        }
        this.getPropertySetChangeListeners().add(listener);
    }

    @Deprecated
    protected void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    protected void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.getPropertySetChangeListeners() != null) {
            this.getPropertySetChangeListeners().remove(listener);
        }
    }

    @Deprecated
    protected void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    protected void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.getItemSetChangeListeners() == null) {
            this.setItemSetChangeListeners(new LinkedList<Container.ItemSetChangeListener>());
        }
        this.getItemSetChangeListeners().add(listener);
    }

    @Deprecated
    protected void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    protected void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.getItemSetChangeListeners() != null) {
            this.getItemSetChangeListeners().remove(listener);
        }
    }

    @Deprecated
    protected void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    protected void fireContainerPropertySetChange() {
        this.fireContainerPropertySetChange(new BasePropertySetChangeEvent(this));
    }

    protected void fireContainerPropertySetChange(Container.PropertySetChangeEvent event) {
        if (this.getPropertySetChangeListeners() != null) {
            Object[] l = this.getPropertySetChangeListeners().toArray();
            for (int i = 0; i < l.length; ++i) {
                ((Container.PropertySetChangeListener)l[i]).containerPropertySetChange(event);
            }
        }
    }

    protected void fireItemSetChange() {
        this.fireItemSetChange(new BaseItemSetChangeEvent(this));
    }

    protected void fireItemSetChange(Container.ItemSetChangeEvent event) {
        if (this.getItemSetChangeListeners() != null) {
            Object[] l = this.getItemSetChangeListeners().toArray();
            for (int i = 0; i < l.length; ++i) {
                ((Container.ItemSetChangeListener)l[i]).containerItemSetChange(event);
            }
        }
    }

    protected void setPropertySetChangeListeners(Collection<Container.PropertySetChangeListener> propertySetChangeListeners) {
        this.propertySetChangeListeners = propertySetChangeListeners;
    }

    protected Collection<Container.PropertySetChangeListener> getPropertySetChangeListeners() {
        return this.propertySetChangeListeners;
    }

    protected void setItemSetChangeListeners(Collection<Container.ItemSetChangeListener> itemSetChangeListeners) {
        this.itemSetChangeListeners = itemSetChangeListeners;
    }

    protected Collection<Container.ItemSetChangeListener> getItemSetChangeListeners() {
        return this.itemSetChangeListeners;
    }

    public Collection<?> getListeners(Class<?> eventType) {
        if (Container.PropertySetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.propertySetChangeListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.propertySetChangeListeners);
        }
        if (Container.ItemSetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.itemSetChangeListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.itemSetChangeListeners);
        }
        return Collections.EMPTY_LIST;
    }

    protected static class BasePropertySetChangeEvent
    extends EventObject
    implements Container.PropertySetChangeEvent,
    Serializable {
        protected BasePropertySetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    protected static class BaseItemSetChangeEvent
    extends EventObject
    implements Container.ItemSetChangeEvent,
    Serializable {
        protected BaseItemSetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }
}

