/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.data.util.AbstractInMemoryContainer;
import com.vaadin.featurepack.data.util.IndexedContainer;
import com.vaadin.featurepack.data.util.converter.ConversionException;
import com.vaadin.featurepack.data.util.converter.ConverterUtil;
import com.vaadin.featurepack.server.FAbstractClientConnector;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.shared.ui.combobox.FilteringMode;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.provider.KeyMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class FAbstractSelect
implements Select {
    private Component component;
    private boolean componentOverridesSetValue;
    private boolean multiSelect = false;
    protected Container items;
    private boolean allowNewOptions;
    protected KeyMapper<Object> itemIdMapper = new KeyMapper();
    private final HashMap<Object, Resource> itemIcons = new HashMap();
    private final HashMap<Object, String> itemCaptions = new HashMap();
    private ItemCaptionMode itemCaptionMode = ItemCaptionMode.EXPLICIT_DEFAULTS_ID;
    private Object itemCaptionPropertyId = null;
    private Object itemIconPropertyId = null;
    private Set<Container.PropertySetChangeListener> propertySetEventListeners = null;
    private Set<Container.ItemSetChangeListener> itemSetEventListeners = null;
    private Object nullSelectionItemId = null;
    private boolean nullSelectionAllowed = true;
    private NewItemHandler newItemHandler;
    CaptionChangeListener captionChangeListener;

    public FAbstractSelect(Component component) {
        this.component = component;
    }

    public FAbstractSelect() {
        this.setContainerDataSource(new IndexedContainer());
    }

    public FAbstractSelect(String caption) {
        this.setContainerDataSource(new IndexedContainer());
        ((FAbstractComponent)this.component).setCaption(caption);
    }

    public FAbstractSelect(String caption, Container dataSource) {
        ((FAbstractComponent)this.component).setCaption(caption);
        this.setContainerDataSource(dataSource);
    }

    public FAbstractSelect(String caption, Collection<?> options) {
        IndexedContainer c = new IndexedContainer();
        if (options != null) {
            Iterator<?> i = options.iterator();
            while (i.hasNext()) {
                c.addItem(i.next());
            }
        }
        ((FAbstractComponent)this.component).setCaption(caption);
        this.setContainerDataSource(c);
    }

    public void setComponentOverridesSetValue(boolean componentOverridesSetValue) {
        this.componentOverridesSetValue = componentOverridesSetValue;
    }

    public boolean isComponentOverridesSetValue() {
        return this.componentOverridesSetValue;
    }

    public void setNewItemHandler(NewItemHandler newItemHandler) {
        this.newItemHandler = newItemHandler;
    }

    public NewItemHandler getNewItemHandler() {
        if (this.newItemHandler == null) {
            this.newItemHandler = new DefaultNewItemHandler();
        }
        return this.newItemHandler;
    }

    public Collection<?> getVisibleItemIds() {
        return this.getItemIds();
    }

    @Override
    public Class<?> getType() {
        if (this.getSelect().isMultiSelect()) {
            return Set.class;
        }
        return Object.class;
    }

    @Override
    public Object getValue() {
        Object retValue = null;
        if (this.component instanceof HasValue) {
            retValue = ((HasValue)this.component).getValue();
        }
        if (this.getSelect().isMultiSelect()) {
            if (retValue == null) {
                return new HashSet();
            }
            if (retValue instanceof Set) {
                return Collections.unmodifiableSet((Set)retValue);
            }
            if (retValue instanceof Collection) {
                return new HashSet((Collection)retValue);
            }
            HashSet<Object> s = new HashSet<Object>();
            if (this.items.containsId(retValue)) {
                s.add(retValue);
            }
            return s;
        }
        return retValue;
    }

    protected void setValue(Object newFieldValue, boolean repaintIsNotNeeded) {
        this.setValue(newFieldValue, repaintIsNotNeeded, false);
    }

    @Override
    public void setValue(Object newValue) throws Property.ReadOnlyException {
        if (newValue == this.getNullSelectionItemId()) {
            newValue = null;
        }
        this.setValue(newValue, false);
    }

    protected void setValue(Object newFieldValue, boolean repaintIsNotNeeded, boolean ignoreReadOnly) throws Property.ReadOnlyException, ConversionException, Validator.InvalidValueException {
        if (this.getSelect().isMultiSelect()) {
            if (newFieldValue == null) {
                ((Field)this.component).getFAbstractField().setValue(new LinkedHashSet(), repaintIsNotNeeded, ignoreReadOnly);
            } else if (Collection.class.isAssignableFrom(newFieldValue.getClass())) {
                ((Field)this.component).getFAbstractField().setValue(new LinkedHashSet((Collection)newFieldValue), repaintIsNotNeeded, ignoreReadOnly);
            }
        } else if ((newFieldValue == null || this.items.containsId(newFieldValue)) && !this.componentOverridesSetValue) {
            ((Field)this.component).getFAbstractField().setValue(newFieldValue, repaintIsNotNeeded, ignoreReadOnly);
        }
    }

    @Override
    public Item getItem(Object itemId) {
        return this.items.getItem(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        return this.items.getItemIds();
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return this.items.getContainerPropertyIds();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.items.getType(propertyId);
    }

    @Override
    public int size() {
        int size = this.items.size();
        assert (size >= 0);
        return size;
    }

    @Override
    public boolean containsId(Object itemId) {
        if (itemId != null) {
            return this.items.containsId(itemId);
        }
        return false;
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.items.getContainerProperty(itemId, propertyId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        boolean retval = this.items.addContainerProperty(propertyId, type, defaultValue);
        if (retval && !(this.items instanceof Container.PropertySetChangeNotifier)) {
            this.firePropertySetChange();
        }
        return retval;
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        boolean retval = this.items.removeAllItems();
        this.itemIdMapper.removeAll();
        if (retval) {
            this.setValue((Object)null);
            if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
                this.fireItemSetChange();
            }
        }
        return retval;
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object retval = this.items.addItem();
        if (retval != null && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        Item retval = this.items.addItem(itemId);
        if (retval != null && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    public void addItems(Object ... itemId) throws UnsupportedOperationException {
        for (Object id : itemId) {
            this.addItem(id);
        }
    }

    public void addItems(Collection<?> itemIds) throws UnsupportedOperationException {
        this.addItems(itemIds.toArray());
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        this.unselect(itemId);
        boolean retval = this.items.removeItem(itemId);
        this.itemIdMapper.remove(itemId);
        if (retval && !(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.fireItemSetChange();
        }
        return retval;
    }

    public void sanitizeSelection() {
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        boolean changed = false;
        if (this.getSelect().isMultiSelect()) {
            Collection valueAsCollection = (Collection)value;
            ArrayList newSelection = new ArrayList(valueAsCollection.size());
            for (Object subValue : valueAsCollection) {
                if (this.containsId(subValue)) {
                    newSelection.add(subValue);
                    continue;
                }
                changed = true;
            }
            if (changed) {
                this.setValue(newSelection);
            }
        } else if (!this.containsId(value)) {
            this.setValue((Object)null);
        }
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) {
        boolean retval = this.items.removeContainerProperty(propertyId);
        if (retval && !(this.items instanceof Container.PropertySetChangeNotifier)) {
            this.firePropertySetChange();
        }
        return retval;
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        if (newDataSource == null) {
            newDataSource = new IndexedContainer();
        }
        this.getCaptionChangeListener().clear();
        if (this.items != newDataSource) {
            if (this.items != null) {
                if (this.items instanceof Container.ItemSetChangeNotifier) {
                    ((Container.ItemSetChangeNotifier)((Object)this.items)).removeItemSetChangeListener((Select)this.component);
                }
                if (this.items instanceof Container.PropertySetChangeNotifier) {
                    ((Container.PropertySetChangeNotifier)((Object)this.items)).removePropertySetChangeListener((Select)this.component);
                }
            }
            this.items = newDataSource;
            this.itemIdMapper.removeAll();
            if (this.items != null) {
                if (this.items instanceof Container.ItemSetChangeNotifier) {
                    ((Container.ItemSetChangeNotifier)((Object)this.items)).addItemSetChangeListener((Select)this.component);
                }
                if (this.items instanceof Container.PropertySetChangeNotifier) {
                    ((Container.PropertySetChangeNotifier)((Object)this.items)).addPropertySetChangeListener((Select)this.component);
                }
            }
            this.setValue((Object)null);
            ((FAbstractComponent)this.component).markAsDirty();
            if (newDataSource instanceof AbstractInMemoryContainer) {
                AbstractInMemoryContainer abstractInMemoryContainer = (AbstractInMemoryContainer)newDataSource;
            }
        }
    }

    @Override
    public Container getContainerDataSource() {
        return this.items;
    }

    @Override
    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect && this.getNullSelectionItemId() != null) {
            throw new IllegalStateException("Multiselect and NullSelectionItemId can not be set at the same time.");
        }
        if (multiSelect != this.multiSelect) {
            Object oldValue = this.getValue();
            this.multiSelect = multiSelect;
            if (multiSelect) {
                HashSet<Object> s = new HashSet<Object>();
                if (oldValue != null) {
                    if (oldValue instanceof Collection) {
                        s.addAll((Collection)oldValue);
                    } else {
                        s.add(oldValue);
                    }
                }
                this.setValue(s);
            } else {
                Set s = (Set)oldValue;
                if (s == null || s.isEmpty()) {
                    this.setValue((Object)null);
                } else {
                    this.setValue(s.iterator().next());
                }
            }
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public boolean isNewItemsAllowed() {
        return this.allowNewOptions;
    }

    @Override
    public void setNewItemsAllowed(boolean allowNewOptions) {
        if (this.allowNewOptions != allowNewOptions) {
            this.allowNewOptions = allowNewOptions;
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    public void setItemCaption(Object itemId, String caption) {
        if (itemId != null) {
            this.itemCaptions.put(itemId, caption);
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public String getItemCaption(Object itemId) {
        if (itemId == null) {
            return null;
        }
        String caption = null;
        switch (this.getItemCaptionMode().ordinal()) {
            case 0: {
                caption = this.idToCaption(itemId);
                break;
            }
            case 1: {
                caption = itemId.toString();
                break;
            }
            case 3: {
                if (this.items instanceof Container.Indexed) {
                    caption = String.valueOf(((Container.Indexed)this.items).indexOfId(itemId));
                    break;
                }
                caption = "ERROR: Container is not indexed";
                break;
            }
            case 2: {
                Item i = this.getItem(itemId);
                if (i == null) break;
                caption = i.toString();
                break;
            }
            case 5: {
                caption = this.itemCaptions.get(itemId);
                break;
            }
            case 4: {
                caption = this.itemCaptions.get(itemId);
                if (caption != null) break;
                caption = this.idToCaption(itemId);
                break;
            }
            case 7: {
                Object value;
                Property p = this.getContainerProperty(itemId, this.getItemCaptionPropertyId());
                if (p == null || (value = p.getValue()) == null) break;
                caption = value.toString();
            }
        }
        return caption != null ? caption : "";
    }

    private String idToCaption(Object itemId) {
        try {
            Converter<String, ?> c = ConverterUtil.getConverter(String.class, itemId.getClass());
            return ConverterUtil.convertFromModel(this.component, itemId, String.class, c);
        }
        catch (Exception e) {
            return itemId.toString();
        }
    }

    @Override
    public void setItemIcon(Object itemId, Resource icon) {
        if (itemId != null) {
            if (icon == null) {
                this.itemIcons.remove(itemId);
            } else {
                this.itemIcons.put(itemId, icon);
            }
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public Resource getItemIcon(Object itemId) {
        Resource explicit = this.itemIcons.get(itemId);
        if (explicit != null) {
            return explicit;
        }
        if (this.getItemIconPropertyId() == null) {
            return null;
        }
        Property ip = this.getContainerProperty(itemId, this.getItemIconPropertyId());
        if (ip == null) {
            return null;
        }
        Object icon = ip.getValue();
        if (icon instanceof Resource) {
            return (Resource)icon;
        }
        return null;
    }

    @Override
    public void setItemCaptionMode(ItemCaptionMode mode) {
        if (mode != null) {
            this.itemCaptionMode = mode;
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public ItemCaptionMode getItemCaptionMode() {
        return this.itemCaptionMode;
    }

    @Override
    public void setItemCaptionPropertyId(Object propertyId) {
        if (propertyId != null) {
            this.itemCaptionPropertyId = propertyId;
            this.setItemCaptionMode(ItemCaptionMode.PROPERTY);
            ((FAbstractComponent)this.component).markAsDirty();
        } else {
            this.itemCaptionPropertyId = null;
            if (this.getItemCaptionMode() == ItemCaptionMode.PROPERTY) {
                this.setItemCaptionMode(ItemCaptionMode.EXPLICIT_DEFAULTS_ID);
            }
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public Object getItemCaptionPropertyId() {
        return this.itemCaptionPropertyId;
    }

    @Override
    public void setItemIconPropertyId(Object propertyId) throws IllegalArgumentException {
        if (propertyId == null) {
            this.itemIconPropertyId = null;
        } else {
            if (!this.getContainerPropertyIds().contains(propertyId)) {
                throw new IllegalArgumentException("Property id not found in the container");
            }
            if (Resource.class.isAssignableFrom(this.getType(propertyId))) {
                this.itemIconPropertyId = propertyId;
            } else {
                throw new IllegalArgumentException("Property type must be assignable to Resource");
            }
        }
        ((FAbstractComponent)this.component).markAsDirty();
    }

    @Override
    public Object getItemIconPropertyId() {
        return this.itemIconPropertyId;
    }

    public boolean isSelected(Object itemId) {
        if (itemId == null) {
            return false;
        }
        if (this.getSelect().isMultiSelect()) {
            return ((Set)this.getValue()).contains(itemId);
        }
        Object value = this.getValue();
        return itemId.equals(value == null ? this.getNullSelectionItemId() : value);
    }

    @Override
    public void select(Object itemId) {
        if (!this.getSelect().isMultiSelect()) {
            this.setValue(itemId);
        } else if (!this.isSelected(itemId) && itemId != null && this.items.containsId(itemId)) {
            HashSet<Object> s = new HashSet<Object>((Set)this.getValue());
            s.add(itemId);
            this.setValue(s);
        }
    }

    public void unselect(Object itemId) {
        if (this.isSelected(itemId)) {
            if (this.getSelect().isMultiSelect()) {
                HashSet s = new HashSet((Set)this.getValue());
                s.remove(itemId);
                this.setValue(s);
            } else {
                this.setValue((Object)null);
            }
        }
    }

    @Override
    public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
        this.firePropertySetChange();
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.propertySetEventListeners == null) {
            this.propertySetEventListeners = new LinkedHashSet<Container.PropertySetChangeListener>();
        }
        this.propertySetEventListeners.add(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.propertySetEventListeners != null) {
            this.propertySetEventListeners.remove(listener);
            if (this.propertySetEventListeners.isEmpty()) {
                this.propertySetEventListeners = null;
            }
        }
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetEventListeners == null) {
            this.itemSetEventListeners = new LinkedHashSet<Container.ItemSetChangeListener>();
        }
        this.itemSetEventListeners.add(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetEventListeners != null) {
            this.itemSetEventListeners.remove(listener);
            if (this.itemSetEventListeners.isEmpty()) {
                this.itemSetEventListeners = null;
            }
        }
    }

    public Collection<?> getListeners(Class<? extends ComponentEvent> eventType) {
        if (Container.ItemSetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.itemSetEventListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.itemSetEventListeners);
        }
        if (Container.PropertySetChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.propertySetEventListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.propertySetEventListeners);
        }
        return ((FAbstractClientConnector)this.component).getFListeners(eventType);
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.itemIdMapper.removeAll();
        this.fireItemSetChange();
    }

    protected void firePropertySetChange() {
        if (this.propertySetEventListeners != null && !this.propertySetEventListeners.isEmpty()) {
            PropertySetChangeEvent event = new PropertySetChangeEvent(this);
            Object[] listeners = this.propertySetEventListeners.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((Container.PropertySetChangeListener)listeners[i]).containerPropertySetChange(event);
            }
        }
        ((FAbstractComponent)this.component).markAsDirty();
    }

    protected void fireItemSetChange() {
        if (this.itemSetEventListeners != null && !this.itemSetEventListeners.isEmpty()) {
            ItemSetChangeEvent event = new ItemSetChangeEvent(this);
            Object[] listeners = this.itemSetEventListeners.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((Container.ItemSetChangeListener)listeners[i]).containerItemSetChange(event);
            }
        }
        ((FAbstractComponent)this.component).markAsDirty();
    }

    @Override
    public boolean isEmpty() {
        if (!this.multiSelect) {
            return ((Field)this.component).getFAbstractField().isEmpty();
        }
        Object value = this.getValue();
        return ((Field)this.component).getFAbstractField().isEmpty() || value instanceof Collection && ((Collection)value).isEmpty();
    }

    @Override
    public void setNullSelectionAllowed(boolean nullSelectionAllowed) {
        if (nullSelectionAllowed != this.nullSelectionAllowed) {
            this.nullSelectionAllowed = nullSelectionAllowed;
            ((FAbstractComponent)this.component).markAsDirty();
        }
    }

    @Override
    public boolean isNullSelectionAllowed() {
        return this.nullSelectionAllowed;
    }

    @Override
    public Object getNullSelectionItemId() {
        return this.nullSelectionItemId;
    }

    @Override
    public void setNullSelectionItemId(Object nullSelectionItemId) {
        if (nullSelectionItemId != null && this.getSelect().isMultiSelect()) {
            throw new IllegalStateException("Multiselect and NullSelectionItemId can not be set at the same time.");
        }
        this.nullSelectionItemId = nullSelectionItemId;
    }

    protected CaptionChangeListener getCaptionChangeListener() {
        if (this.captionChangeListener == null) {
            this.captionChangeListener = new CaptionChangeListener();
        }
        return this.captionChangeListener;
    }

    private Select getSelect() {
        return (Select)this.component;
    }

    public static enum ItemCaptionMode {
        ID,
        ID_TOSTRING,
        ITEM,
        INDEX,
        EXPLICIT_DEFAULTS_ID,
        EXPLICIT,
        ICON_ONLY,
        PROPERTY;

    }

    public static interface NewItemHandler
    extends Serializable {
        public void addNewItem(String var1);
    }

    public class DefaultNewItemHandler
    implements NewItemHandler {
        @Override
        public void addNewItem(String newItemCaption) {
            if (((Field)FAbstractSelect.this.component).isPropertyReadOnly()) {
                throw new Property.ReadOnlyException();
            }
            if (FAbstractSelect.this.addItem(newItemCaption) != null) {
                if (FAbstractSelect.this.getItemCaptionPropertyId() != null) {
                    FAbstractSelect.this.getContainerProperty(newItemCaption, FAbstractSelect.this.getItemCaptionPropertyId()).setValue(newItemCaption);
                }
                if (FAbstractSelect.this.getSelect().isMultiSelect()) {
                    HashSet<String> values = new HashSet<String>((Collection)FAbstractSelect.this.getValue());
                    values.add(newItemCaption);
                    FAbstractSelect.this.setValue(values);
                } else {
                    FAbstractSelect.this.setValue(newItemCaption);
                }
            }
        }
    }

    protected class CaptionChangeListener
    implements Item.PropertySetChangeListener,
    Property.ValueChangeListener {
        HashSet<Object> captionChangeNotifiers = new HashSet();

        protected CaptionChangeListener() {
        }

        public void addNotifierForItem(Object itemId) {
            Property p;
            switch (FAbstractSelect.this.getItemCaptionMode().ordinal()) {
                case 2: {
                    Collection<?> pids;
                    Item i = FAbstractSelect.this.getItem(itemId);
                    if (i == null) {
                        return;
                    }
                    if (i instanceof Item.PropertySetChangeNotifier) {
                        ((Item.PropertySetChangeNotifier)((Object)i)).addPropertySetChangeListener(FAbstractSelect.this.getCaptionChangeListener());
                        this.captionChangeNotifiers.add(i);
                    }
                    if ((pids = i.getItemPropertyIds()) == null) break;
                    Iterator<?> it = pids.iterator();
                    while (it.hasNext()) {
                        Property p2 = i.getItemProperty(it.next());
                        if (p2 == null || !(p2 instanceof Property.ValueChangeNotifier)) continue;
                        ((Property.ValueChangeNotifier)((Object)p2)).addValueChangeListener(FAbstractSelect.this.getCaptionChangeListener());
                        this.captionChangeNotifiers.add(p2);
                    }
                    break;
                }
                case 7: {
                    Property p3 = FAbstractSelect.this.getContainerProperty(itemId, FAbstractSelect.this.getItemCaptionPropertyId());
                    if (p3 == null || !(p3 instanceof Property.ValueChangeNotifier)) break;
                    ((Property.ValueChangeNotifier)((Object)p3)).addValueChangeListener(FAbstractSelect.this.getCaptionChangeListener());
                    this.captionChangeNotifiers.add(p3);
                }
            }
            if (FAbstractSelect.this.getItemIconPropertyId() != null && (p = FAbstractSelect.this.getContainerProperty(itemId, FAbstractSelect.this.getItemIconPropertyId())) != null && p instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)p)).addValueChangeListener(FAbstractSelect.this.getCaptionChangeListener());
                this.captionChangeNotifiers.add(p);
            }
        }

        public void clear() {
            for (Object notifier : this.captionChangeNotifiers) {
                if (notifier instanceof Item.PropertySetChangeNotifier) {
                    ((Item.PropertySetChangeNotifier)notifier).removePropertySetChangeListener(FAbstractSelect.this.getCaptionChangeListener());
                    continue;
                }
                ((Property.ValueChangeNotifier)notifier).removeValueChangeListener(FAbstractSelect.this.getCaptionChangeListener());
            }
            this.captionChangeNotifiers.clear();
        }

        @Override
        public void valueChange(Property.ValueChangeEvent event) {
            ((FAbstractComponent)FAbstractSelect.this.component).markAsDirty();
        }

        @Override
        public void itemPropertySetChange(Item.PropertySetChangeEvent event) {
            ((FAbstractComponent)FAbstractSelect.this.component).markAsDirty();
        }
    }

    private static class PropertySetChangeEvent
    extends EventObject
    implements Container.PropertySetChangeEvent,
    Serializable {
        private PropertySetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    private static class ItemSetChangeEvent
    extends EventObject
    implements Serializable,
    Container.ItemSetChangeEvent {
        private ItemSetChangeEvent(Container source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    public static interface ItemDescriptionGenerator
    extends Serializable {
        public String generateDescription(Component var1, Object var2, Object var3);
    }

    public static interface Filtering
    extends Serializable {
        public void setFilteringMode(FilteringMode var1);

        public FilteringMode getFilteringMode();
    }
}

