/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.featurepack.data.converter.Converter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public class StringToDateConverter
implements Converter<String, Date> {
    protected DateFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat f = DateFormat.getDateTimeInstance(2, 2, locale);
        f.setLenient(false);
        return f;
    }

    @Override
    public Date convertToModel(String value, Class<? extends Date> targetType, Locale locale) throws Converter.ConversionException {
        if (targetType != this.getModelType()) {
            throw new Converter.ConversionException("Converter only supports " + this.getModelType().getName() + " (targetType was " + targetType.getName() + ")");
        }
        if (value == null) {
            return null;
        }
        value = value.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        Date parsedValue = this.getFormat(locale).parse(value, parsePosition);
        if (parsePosition.getIndex() != value.length()) {
            throw new Converter.ConversionException("Could not convert '" + value + "' to " + this.getModelType().getName());
        }
        return parsedValue;
    }

    @Override
    public String convertToPresentation(Date value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        return this.getFormat(locale).format(value);
    }

    @Override
    public Class<Date> getModelType() {
        return Date.class;
    }

    @Override
    public Class<String> getPresentationType() {
        return String.class;
    }
}

