/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ItemDataProvider
extends AbstractBackEndDataProvider<Item, SerializablePredicate<Item>> {
    private final Map<Item, Object> itemToItemIdMap = new HashMap<Item, Object>();
    private final SerializableSupplier<Container> containerSupplier;

    public ItemDataProvider(SerializableSupplier<Container> containerSupplier) {
        this.containerSupplier = containerSupplier;
    }

    public Container getContainerDataSource() {
        return (Container)this.containerSupplier.get();
    }

    protected Stream<Item> fetchFromBackEnd(Query<Item, SerializablePredicate<Item>> query) {
        Container container = this.getContainerDataSource();
        List<Object> itemIds = container instanceof Container.Indexed ? ((Container.Indexed)container).getItemIds(query.getOffset(), query.getLimit()) : container.getItemIds().stream().skip(query.getOffset()).limit(query.getLimit()).collect(Collectors.toList());
        Stream<Item> stream = itemIds.stream().map(id -> {
            Item item = this.getContainerDataSource().getItem(id);
            this.itemToItemIdMap.put(item, id);
            return item;
        });
        if (query.getFilter().isPresent()) {
            stream = stream.filter((Predicate)query.getFilter().get());
        }
        return stream;
    }

    protected int sizeInBackEnd(Query<Item, SerializablePredicate<Item>> query) {
        return this.getContainerDataSource().size();
    }

    public Object getItemId(Item item) {
        return this.itemToItemIdMap.get(item);
    }

    public void clear() {
        this.itemToItemIdMap.clear();
    }

    public void put(Item item, Object itemId) {
        this.itemToItemIdMap.put(item, itemId);
    }
}

