/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.util.filter.UnsupportedFilterException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface Container
extends Serializable {
    public Item getItem(Object var1);

    public Collection<?> getContainerPropertyIds();

    public Collection<?> getItemIds();

    public Property getContainerProperty(Object var1, Object var2);

    public Class<?> getType(Object var1);

    public int size();

    public boolean containsId(Object var1);

    public Item addItem(Object var1) throws UnsupportedOperationException;

    public Object addItem() throws UnsupportedOperationException;

    public boolean removeItem(Object var1) throws UnsupportedOperationException;

    public boolean addContainerProperty(Object var1, Class<?> var2, Object var3) throws UnsupportedOperationException;

    public boolean removeContainerProperty(Object var1) throws UnsupportedOperationException;

    public boolean removeAllItems() throws UnsupportedOperationException;

    public static interface PropertySetChangeNotifier
    extends Serializable {
        public void addPropertySetChangeListener(PropertySetChangeListener var1);

        public void removePropertySetChangeListener(PropertySetChangeListener var1);
    }

    public static interface PropertySetChangeListener
    extends Serializable {
        public void containerPropertySetChange(PropertySetChangeEvent var1);
    }

    public static interface PropertySetChangeEvent
    extends Serializable {
        public Container getContainer();
    }

    public static interface ItemSetChangeNotifier
    extends Serializable {
        public void addItemSetChangeListener(ItemSetChangeListener var1);

        public void removeItemSetChangeListener(ItemSetChangeListener var1);
    }

    public static interface ItemSetChangeListener
    extends Serializable {
        public void containerItemSetChange(ItemSetChangeEvent var1);
    }

    public static interface ItemSetChangeEvent
    extends Serializable {
        public Container getContainer();
    }

    public static interface Editor
    extends Viewer,
    Serializable {
    }

    public static interface Viewer
    extends Serializable {
        public void setContainerDataSource(Container var1);

        public Container getContainerDataSource();
    }

    public static interface Filterable
    extends Container,
    Serializable {
        public void addContainerFilter(Filter var1) throws UnsupportedFilterException;

        public void removeContainerFilter(Filter var1);

        public void removeAllContainerFilters();

        public Collection<Filter> getContainerFilters();
    }

    public static interface Filter
    extends Serializable {
        public boolean passesFilter(Object var1, Item var2) throws UnsupportedOperationException;

        public boolean appliesToProperty(Object var1);
    }

    public static interface SimpleFilterable
    extends Container,
    Serializable {
        public void addContainerFilter(Object var1, String var2, boolean var3, boolean var4);

        public void removeAllContainerFilters();

        public void removeContainerFilters(Object var1);
    }

    public static interface Hierarchical
    extends Container {
        public Collection<?> getChildren(Object var1);

        public Object getParent(Object var1);

        public Collection<?> rootItemIds();

        public boolean setParent(Object var1, Object var2) throws UnsupportedOperationException;

        public boolean areChildrenAllowed(Object var1);

        public boolean setChildrenAllowed(Object var1, boolean var2) throws UnsupportedOperationException;

        public boolean isRoot(Object var1);

        public boolean hasChildren(Object var1);

        @Override
        public boolean removeItem(Object var1) throws UnsupportedOperationException;
    }

    public static interface Indexed
    extends Ordered {
        public int indexOfId(Object var1);

        public Object getIdByIndex(int var1);

        public List<?> getItemIds(int var1, int var2);

        public Object addItemAt(int var1) throws UnsupportedOperationException;

        public Item addItemAt(int var1, Object var2) throws UnsupportedOperationException;

        public static interface ItemRemoveEvent
        extends ItemSetChangeEvent {
            public Object getFirstItemId();

            public int getFirstIndex();

            public int getRemovedItemsCount();
        }

        public static interface ItemAddEvent
        extends ItemSetChangeEvent {
            public Object getFirstItemId();

            public int getFirstIndex();

            public int getAddedItemsCount();
        }
    }

    public static interface Sortable
    extends Ordered {
        public void sort(Object[] var1, boolean[] var2);

        public Collection<?> getSortableContainerPropertyIds();
    }

    public static interface Ordered
    extends Container {
        public Object nextItemId(Object var1);

        public Object prevItemId(Object var1);

        public Object firstItemId();

        public Object lastItemId();

        public boolean isFirstId(Object var1);

        public boolean isLastId(Object var1);

        public Object addItemAfter(Object var1) throws UnsupportedOperationException;

        public Item addItemAfter(Object var1, Object var2) throws UnsupportedOperationException;
    }
}

