/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.util.UpdatingDataGenerator;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Optional;

public class GridRendererAdapter<T, V>
extends BasicRenderer<T, V> {
    private final ValueProvider<T, V> valueProvider;
    private final Renderer<V> renderer;
    private Converter<?, V> converter;

    public GridRendererAdapter(ValueProvider<T, V> valueProvider, Renderer<V> renderer, Converter<?, V> converter) {
        super(valueProvider);
        this.valueProvider = valueProvider;
        this.renderer = renderer;
        this.converter = converter;
    }

    public Component createComponent(T item) {
        if (this.renderer instanceof ComponentRenderer) {
            return ((ComponentRenderer)this.renderer).createComponent(item);
        }
        return super.createComponent(item);
    }

    public Component updateComponent(Component currentComponent, T item) {
        if (this.renderer instanceof ComponentRenderer) {
            return ((ComponentRenderer)this.renderer).updateComponent(currentComponent, item);
        }
        return super.updateComponent(currentComponent, item);
    }

    public Rendering<T> render(Element container, DataKeyMapper<T> keyMapper, String rendererName) {
        return (Rendering & Serializable)() -> Optional.of(new UpdatingDataGenerator(this.renderer.render(container, keyMapper, rendererName), this::getValue));
    }

    private V getValue(T item) {
        return (V)(this.isValueProviderConverted() ? this.converter.convertToPresentation(this.valueProvider.apply(item), new ValueContext((Binder)null)) : this.valueProvider.apply(item));
    }

    public void setConverter(Converter<?, ?> converter) {
        this.converter = converter;
    }

    public Converter<?, V> getConverter() {
        return this.converter;
    }

    protected boolean isValueProviderConverted() {
        return this.converter != null;
    }
}

