/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui.renderers;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.ui.FGrid;
import com.vaadin.featurepack.util.GridRendererAdapter;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DateRenderer
extends FGrid.AbstractRenderer<Date> {
    private final Locale locale;
    private final String formatString;
    private final DateFormat dateFormat;
    private Renderer<Date> renderer;

    public DateRenderer() {
        this(Locale.getDefault(), "");
    }

    public DateRenderer(Locale locale) throws IllegalArgumentException {
        this("%s", locale, "");
    }

    public DateRenderer(Locale locale, String nullRepresentation) throws IllegalArgumentException {
        this("%s", locale, nullRepresentation);
    }

    public DateRenderer(String formatString) throws IllegalArgumentException {
        this(formatString, "");
    }

    public DateRenderer(String formatString, String nullRepresentation) throws IllegalArgumentException {
        this(formatString, Locale.getDefault(), nullRepresentation);
    }

    public DateRenderer(String formatString, Locale locale) throws IllegalArgumentException {
        this(formatString, locale, "");
    }

    public DateRenderer(String formatString, Locale locale, String nullRepresentation) throws IllegalArgumentException {
        super(Date.class, nullRepresentation);
        if (formatString == null) {
            throw new IllegalArgumentException("format string may not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale may not be null");
        }
        this.locale = locale;
        this.formatString = formatString;
        this.dateFormat = null;
        this.renderer = new GridRendererAdapter((ValueProvider & Serializable)item -> ((Item)item).getItemProperty(this.getPropertyId()).getValue(), new TextRenderer((ItemLabelGenerator & Serializable)value -> {
            String dateString = value == null ? this.getNullRepresentation() : (this.dateFormat != null ? this.dateFormat.format(value) : String.format(this.locale, this.formatString, value));
            return dateString;
        }), null);
    }

    public DateRenderer(DateFormat dateFormat) throws IllegalArgumentException {
        this(dateFormat, "");
    }

    public DateRenderer(DateFormat dateFormat, String nullRepresentation) throws IllegalArgumentException {
        super(Date.class, nullRepresentation);
        if (dateFormat == null) {
            throw new IllegalArgumentException("date format may not be null");
        }
        this.locale = null;
        this.formatString = null;
        this.dateFormat = dateFormat;
    }

    @Override
    public String getNullRepresentation() {
        return super.getNullRepresentation();
    }

    public String toString() {
        String fieldInfo = this.dateFormat != null ? "dateFormat: " + this.dateFormat.toString() : "locale: " + String.valueOf(this.locale) + ", formatString: " + this.formatString;
        return String.format("%s [%s]", this.getClass().getSimpleName(), fieldInfo);
    }

    @Override
    public Renderer<Date> getRenderer() {
        return this.renderer;
    }
}

