/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui.renderers;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.event.MouseEvents;
import com.vaadin.featurepack.shared.MouseEventDetails;
import com.vaadin.featurepack.ui.FGrid;
import com.vaadin.featurepack.util.GridRendererAdapter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ClickableRenderer<T>
extends FGrid.AbstractRenderer<T> {
    protected GridRendererAdapter renderer;
    protected final Set<RendererClickListener> clickListeners = new HashSet<RendererClickListener>();

    protected ClickableRenderer(Class<T> presentationType) {
        this(presentationType, null);
    }

    protected ClickableRenderer(Class<T> presentationType, String nullRepresentation) {
        super(presentationType, nullRepresentation);
    }

    public void addClickListener(RendererClickListener listener) {
        this.clickListeners.add(listener);
    }

    public void removeClickListener(RendererClickListener listener) {
        this.clickListeners.remove(listener);
    }

    @Override
    public Renderer<T> getRenderer() {
        if (this.renderer == null) {
            this.renderer = new GridRendererAdapter((ValueProvider & Serializable)item -> item, (Renderer)this.createClickableWrapperComponentRenderer(), null){

                @Override
                protected boolean isValueProviderConverted() {
                    return false;
                }
            };
        }
        return this.renderer;
    }

    protected ComponentRenderer<Component, Item> createClickableWrapperComponentRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            Object value = item.getItemProperty(this.getPropertyId()).getValue();
            if (this.renderer.getConverter() != null) {
                value = this.renderer.getConverter().convertToPresentation(value, new ValueContext((Binder)null));
            }
            Element span = ElementFactory.createSpan((String)((String)value == null ? this.getNullRepresentation() : String.valueOf(value)));
            Span component = (Span)ComponentUtil.componentFromElement((Element)span, Span.class, (boolean)true);
            ComponentUtil.addListener((Component)component, RendererClickEvent.class, (ComponentEventListener & Serializable)event -> {
                event.itemId = this.getItemId((Item)item);
                event.column = this.getColumn((String)this.getPropertyId());
                this.clickListeners.forEach(listener -> listener.click((RendererClickEvent)event));
            });
            return component;
        });
    }

    @DomEvent(value="click")
    public static class RendererClickEvent
    extends MouseEvents.AbstractClickEvent {
        protected Object itemId;
        protected FGrid.Column column;

        public RendererClickEvent(Component source, boolean fromClient, @EventData(value="event.clientX") int clientX, @EventData(value="event.clientY") int clientY, @EventData(value="event.detail") int clickCount, @EventData(value="event.button") int button, @EventData(value="event.ctrlKey") boolean ctrlKey, @EventData(value="event.shiftKey") boolean shiftKey, @EventData(value="event.altKey") boolean altKey, @EventData(value="event.metaKey") boolean metaKey, @EventData(value="event.clientX - element.getBoundingClientRect().x") int relativeX, @EventData(value="event.clientY - element.getBoundingClientRect().y") int relativeY) {
            super(source, fromClient, clientX, clientY, clickCount, button, ctrlKey, shiftKey, altKey, metaKey, relativeX, relativeY);
        }

        protected RendererClickEvent(FGrid source, Object itemId, FGrid.Column column, MouseEventDetails mouseEventDetails) {
            super((Component)source, mouseEventDetails);
            this.itemId = itemId;
            this.column = column;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public FGrid.Column getColumn() {
            return this.column;
        }

        public Object getPropertyId() {
            return this.column.getPropertyId();
        }
    }

    @FunctionalInterface
    public static interface RendererClickListener
    extends ComponentEventListener<RendererClickEvent> {
        default public void onComponentEvent(RendererClickEvent event) {
            this.click(event);
        }

        public void click(RendererClickEvent var1);
    }
}

