/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.IconRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;

public class Vaadin8ComboBox<T>
extends ComboBox<T> {
    private SerializableFunction<T, String> itemStyleGenerator;
    private SerializableFunction<T, Icon> itemIconGenerator;

    public Vaadin8ComboBox(int pageSize) {
        super(pageSize);
    }

    public Vaadin8ComboBox() {
    }

    public Vaadin8ComboBox(String label) {
        super(label);
    }

    public Vaadin8ComboBox(String label, Collection<T> items) {
        super(label, items);
    }

    @SafeVarargs
    public Vaadin8ComboBox(String label, T ... items) {
        super(label, (Object[])items);
    }

    public void setItemCaptionGenerator(ItemLabelGenerator<T> itemCaptionGenerator) {
        this.setItemLabelGenerator(itemCaptionGenerator);
        if (this.itemIconGenerator != null) {
            this.setItemIconGenerator(this.itemIconGenerator);
        } else if (this.itemStyleGenerator != null) {
            this.setStyleGenerator(this.itemStyleGenerator);
        } else {
            this.setRenderer((Renderer)new TextRenderer(itemCaptionGenerator));
        }
    }

    public void setStyleGenerator(SerializableFunction<T, String> itemStyleGenerator) {
        this.itemStyleGenerator = itemStyleGenerator;
        if (this.itemIconGenerator != null) {
            this.setItemIconGenerator(this.itemIconGenerator);
        } else {
            this.setRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)item -> {
                Span span = new Span(this.getItemLabelGenerator().apply(item));
                String style = (String)itemStyleGenerator.apply(item);
                span.getElement().getClassList().add((Object)((String)itemStyleGenerator.apply(item)));
                if (style != null && !style.isBlank()) {
                    span.getElement().getClassList().add((Object)style);
                }
                return span;
            }));
        }
    }

    public void setItemIconGenerator(SerializableFunction<T, Icon> itemIconGenerator) {
        this.itemIconGenerator = itemIconGenerator;
        final SerializableFunction<T, String> localItemStyleGenerator = this.itemStyleGenerator;
        this.setRenderer((Renderer)new IconRenderer<T>(itemIconGenerator, this.getItemLabelGenerator()){

            public Component createComponent(T item) {
                String style;
                Component iconComponen = super.createComponent(item);
                if (localItemStyleGenerator != null && (style = (String)localItemStyleGenerator.apply(item)) != null && !style.isBlank()) {
                    iconComponen.getElement().getClassList().add((Object)style);
                }
                return iconComponen;
            }
        });
    }
}

