/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.event.MouseEvents;
import com.vaadin.featurepack.ui.AbstractSingleComponentContainer;
import com.vaadin.featurepack.ui.Focusable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import tools.jackson.databind.JsonNode;

@CssImport.Container(value={@CssImport(value="./panel.css"), @CssImport(value="@vaadin/vaadin-lumo-styles/lumo.css")})
@Tag(value="div")
public class Panel
extends AbstractSingleComponentContainer
implements Focusable,
Serializable {
    private static final String V_PANEL = "v-panel";
    private static final String V_CONTENT = "v-panel-content";
    private static final String V_NO_CAPTION = "v-panel-nocaption";
    private static final String V_CAPTION = "v-panel-caption";
    private static final String V_SCROLLABLE = "v-scrollable";
    private static final String V_CAPTION_WRAP = "v-panel-captionwrap";
    private static final int SCROLL_EVENT_DEBOUNCE_TIMEOUT = 300;
    private final Element captionElement;
    private final Element captionContent;
    private final Element scrollable;
    private boolean isContextMenuPrevented = false;

    public Panel() {
        this.setPrimaryStyleName(V_PANEL);
        this.captionContent = ElementFactory.createSpan();
        this.captionElement = ElementFactory.createDiv();
        this.captionElement.appendChild(new Element[]{this.captionContent});
        Element captionWrap = ElementFactory.createDiv();
        captionWrap.appendChild(new Element[]{this.captionElement});
        captionWrap.getClassList().set(V_CAPTION_WRAP, true);
        this.scrollable = new Element("vaadin-scroller");
        ComponentUtil.componentFromElement((Element)this.scrollable, Scroller.class, (boolean)false);
        this.scrollable.addEventListener("scroll", this::scrollEventListener).debounce(300).addEventData("element.scrollTop").addEventData("element.scrollLeft");
        this.getElement().appendChild(new Element[]{captionWrap});
        this.setContentWrapper(this.scrollable);
        this.writeCustomStylesToInternalElements();
        this.setWidth(100.0f, Unit.PERCENTAGE);
    }

    public Panel(Component content) {
        this();
        this.setContent(content);
    }

    public Panel(String caption) {
        this();
        this.setCaption(caption);
    }

    public Panel(String caption, Component content) {
        this();
        this.setCaption(caption);
        this.setContent(content);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        this.writeCustomStylesToInternalElements();
    }

    public Registration addClickListener(MouseEvents.ClickListener listener) {
        if (!this.isContextMenuPrevented) {
            this.getElement().addEventListener("contextmenu", (DomEventListener & Serializable)evt -> {}).addEventData("event.preventDefault()");
            this.isContextMenuPrevented = true;
        }
        return ComponentUtil.addListener((Component)this, MouseEvents.ClickEvent.class, (ComponentEventListener)listener);
    }

    private void writeCustomStylesToInternalElements() {
        String captionBaseClass = this.getCaption() == null || this.getCaption().isEmpty() ? V_NO_CAPTION : V_CAPTION;
        ArrayList<String> captionStylesList = new ArrayList<String>();
        captionStylesList.add(captionBaseClass);
        ArrayList<String> contentStyleList = new ArrayList<String>();
        contentStyleList.add(V_CONTENT);
        this.getCustomStyles().forEach(style -> {
            captionStylesList.add(captionBaseClass + "-" + style);
            contentStyleList.add("v-panel-content-" + style);
        });
        this.captionElement.getClassList().clear();
        this.captionElement.getClassList().addAll(captionStylesList);
        contentStyleList.add(V_SCROLLABLE);
        this.scrollable.getClassList().clear();
        this.scrollable.getClassList().addAll(contentStyleList);
    }

    @Override
    public void setCaption(String caption) {
        super.setCaption(caption);
        this.updateCaptionText();
        this.markAsDirty();
    }

    public void setLabel(String label) {
        super.setLabel(label);
        this.setCaption(label);
    }

    @Override
    public String getCaption() {
        return super.getCaption();
    }

    @Override
    public void setCaptionAsHtml(boolean captionAsHtml) {
        super.setCaptionAsHtml(captionAsHtml);
        this.updateCaptionText();
    }

    private void updateCaptionText() {
        String text;
        String string = text = this.getCaption() != null && this.getCaption().isEmpty() ? "\u00a0" : this.getCaption();
        if (text != null && this.isCaptionAsHtml()) {
            this.captionContent.setProperty("innerHTML", Jsoup.clean((String)text, (Safelist)Safelist.relaxed()));
        } else {
            this.captionContent.setText(text);
        }
    }

    @Override
    public boolean isCaptionAsHtml() {
        return super.isCaptionAsHtml();
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.getIcon() == null) {
            super.setIcon(icon);
            this.getIconAsIcon().addClassName("v-icon");
            this.captionElement.insertChild(0, new Element[]{this.getIconAsIcon().getElement()});
        } else {
            super.setIcon(icon);
        }
    }

    @Override
    public void setIcon(IconFactory icon) {
        this.setIcon(icon.create());
    }

    public Icon getIconAsIcon() {
        return (Icon)super.getIcon();
    }

    public int getScrollLeft() {
        return this.scrollable.getProperty("scrollLeft", 0);
    }

    public void setScrollLeft(int scrollLeft) {
        this.scrollable.setProperty("scrollLeft", (double)scrollLeft);
        this.scrollable.executeJs("this.scrollLeft=$0", new Object[]{scrollLeft});
    }

    public int getScrollTop() {
        return this.scrollable.getProperty("scrollTop", 0);
    }

    public void setScrollTop(int scrollTop) {
        this.scrollable.setProperty("scrollTop", (double)scrollTop);
        this.scrollable.executeJs("this.scrollTop=$0", new Object[]{scrollTop});
    }

    private void scrollEventListener(DomEvent e) {
        ElementPropertyMap scrollablePropertyMap = (ElementPropertyMap)this.scrollable.getNode().getFeature(ElementPropertyMap.class);
        Double scrollTop = Panel.toDouble(e.getEventData().get("element.scrollTop"));
        Double scrollLeft = Panel.toDouble(e.getEventData().get("element.scrollLeft"));
        scrollablePropertyMap.setProperty("scrollTop", (Serializable)scrollTop);
        scrollablePropertyMap.setProperty("scrollLeft", (Serializable)scrollLeft);
        Map changes = (Map)((Object)this.scrollable.getNode().getChangeTracker((NodeFeature)scrollablePropertyMap, () -> null));
        if (changes != null) {
            changes.remove("scrollTop");
            changes.remove("scrollLeft");
        }
    }

    private static Double toDouble(JsonNode jsonNode) {
        return jsonNode.isEmpty() ? null : Double.valueOf(jsonNode.asDouble());
    }

    @Override
    public void focus() {
        this.scrollable.executeJs("setTimeout(function(){$0.focus()},0)", new Object[]{this.scrollable});
    }

    @Override
    public int getTabIndex() {
        return this.scrollable.getProperty("tabIndex", -1);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (tabIndex == -1 && this.getTabIndex() == -1) {
            this.scrollable.executeJs("this.tabIndex=$0", new Object[]{tabIndex});
        }
        this.scrollable.setProperty("tabIndex", (double)tabIndex);
    }
}

