/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.ui.AbstractOrderedLayout;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.HtmlTable;
import com.vaadin.featurepack.ui.MarginInfo;
import com.vaadin.featurepack.ui.TableDataCell;
import com.vaadin.featurepack.ui.TableRow;
import com.vaadin.featurepack.util.TooltipUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.popover.Popover;
import java.util.UUID;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport.Container(value={@CssImport(value="./ordered-layout.css"), @CssImport(value="./margin.css")})
@JsModule(value="./form-layout-styles.js")
public class FormLayout
extends AbstractOrderedLayout {
    private static final String CLASSNAME = "v-formlayout";
    public static final String IN_FORM_LAYOUT_THEME = "in-form-layout";
    private final HtmlTable table = new HtmlTable();

    public FormLayout() {
        super(true);
        this.add(this.table);
        this.setPrimaryStyleName(CLASSNAME);
        this.setMargin(new MarginInfo(true, false));
        this.addStyleName("outlined");
    }

    public FormLayout(Component ... children) {
        this();
        this.addComponents(children);
    }

    @Override
    @Deprecated
    public float getExpandRatio(Component component) {
        return 0.0f;
    }

    @Override
    public void setExpandRatio(Component component, float ratio) {
    }

    @Override
    public void addComponent(Component component) {
        if (component == this.table) {
            super.addComponent(component);
        } else {
            if (component instanceof HasTheme) {
                ((HasTheme)component).addThemeName(IN_FORM_LAYOUT_THEME);
            }
            FormRow row = new FormRow(component);
            this.table.addComponent(row);
        }
    }

    @Override
    public void removeComponent(Component component) {
        this.table.getChildren().map(row -> (FormRow)row).filter(row -> row.getContent().equals(component)).findFirst().ifPresent(xva$0 -> this.table.remove((Component)xva$0));
    }

    @Override
    public int getComponentIndex(Component component) {
        return this.table.getChildren().map(row -> (FormRow)row).map(FormRow::getContent).toList().indexOf(component);
    }

    @Override
    public Component getComponent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.table.getComponentCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.table.getChildren().skip(index).findFirst().map(component -> (FormRow)component).map(FormRow::getContent).orElseThrow();
    }

    @Override
    public void addComponent(Component component, int index) throws IndexOutOfBoundsException {
        int componentCount = this.table.getComponentCount();
        if (index < 0 || index > componentCount) {
            throw new IndexOutOfBoundsException();
        }
        if (componentCount == 0 || index == componentCount) {
            this.add(component);
            return;
        }
        if (component instanceof HasTheme) {
            ((HasTheme)component).addThemeName(IN_FORM_LAYOUT_THEME);
        }
        FormRow row = new FormRow(component);
        this.table.addComponentAtIndex(index, row);
    }

    HtmlTable getTable() {
        return this.table;
    }

    @Override
    protected void setSlotClasses() {
    }

    @Override
    public Stream<Component> getChildren() {
        return this.table.getChildren().map(row -> (FormRow)row).map(FormRow::getContent);
    }

    public void updateCaptions() {
        this.table.getChildren().map(FormRow.class::cast).forEach(FormRow::updateCaption);
    }

    static final class FormRow
    extends TableRow {
        private final TableDataCell captionCell;
        private final TableDataCell contentCell;

        FormRow(Component component) {
            this.addStyleName("v-formlayout-row");
            this.captionCell = new TableDataCell();
            this.captionCell.addStyleName("v-formlayout-captioncell");
            this.contentCell = new TableDataCell(component);
            this.contentCell.addStyleName("v-formlayout-contentcell");
            this.updateCaption();
            this.add(this.captionCell, this.contentCell);
        }

        Component getContent() {
            return this.contentCell.getContent();
        }

        public void updateCaption() {
            HasValue hasValue;
            boolean required;
            HasLabel labeledComponent;
            String labelText;
            Component component = this.getContent();
            String string = labelText = component instanceof HasLabel && (labeledComponent = (HasLabel)component).getLabel() != null && !labeledComponent.getLabel().isBlank() ? labeledComponent.getLabel() : "";
            if (component instanceof FAbstractComponent) {
                FAbstractComponent fAbstractComponent = (FAbstractComponent)component;
                labelText = fAbstractComponent.getCaption();
                Popover tooltip = TooltipUtils.getPopover(fAbstractComponent.getFlowComponent());
                if (tooltip != null) {
                    String id = UUID.randomUUID().toString();
                    this.setId(id);
                    tooltip.setFor(id);
                }
            }
            boolean bl = required = component instanceof HasValue && (hasValue = (HasValue)component).isRequiredIndicatorVisible();
            if (component instanceof Field) {
                Field field = (Field)component;
                required = field.isRequired();
            }
            component.getElement().executeJs("        const vCaption = this.querySelector('span.v-caption');\n        if ($1) {\n            this.closest('tr').firstChild.innerHTML = `<span>` + (this.querySelector('span[slot=\"label\"]')?.innerHTML || vCaption?.innerHTML || $0) + `</span><span class=\"v-required-field-indicator\">*</span>`;\n        } else {\n            this.closest('tr').firstChild.innerHTML = `<span>` + (this.querySelector('span[slot=\"label\"]')?.innerHTML || vCaption?.innerHTML || $0) + `</span>`;\n        }\n        if(vCaption && this.tagName.toLowerCase() !== 'vaadin-checkbox') {\n            vCaption.style.display = 'none';\n        }\n        // clear label columns for checkboxes\n        if (this.tagName.toLowerCase() === 'vaadin-checkbox') {\n            this.closest('tr').firstChild.innerText = '';\n        }\n", new Object[]{labelText != null ? labelText : "", required});
        }
    }
}

