/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.ui.FAbstractSelect;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.shared.ui.combobox.FilteringMode;
import com.vaadin.featurepack.ui.CustomField;
import com.vaadin.featurepack.ui.FButton;
import com.vaadin.featurepack.ui.FComboBox;
import com.vaadin.featurepack.ui.HorizontalLayout;
import com.vaadin.featurepack.ui.Layout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class FTokenField
extends CustomField<Object>
implements Container.Editor {
    public static final String STYLE_TOKENFIELD = "tokenfield";
    public static final String STYLE_TOKENTEXTFIELD = "tokentextfield";
    public static final String STYLE_BUTTON_EMPHAZISED = "emphasize";
    protected HasComponents layout;
    protected InsertPosition insertPosition = InsertPosition.BEFORE;
    protected FComboBox cb = new FComboBox();
    protected LinkedHashMap<Object, FButton> buttons = new LinkedHashMap();
    protected boolean rememberNewTokens = true;

    public FTokenField(String caption, InsertPosition insertPosition) {
        this();
        this.insertPosition = insertPosition;
        this.setCaption(caption);
    }

    public FTokenField(String caption) {
        this();
        this.setCaption(caption);
    }

    public FTokenField() {
        this((HasComponents)new Div());
    }

    public FTokenField(String caption, Layout lo) {
        this(lo);
        this.setCaption(caption);
    }

    public FTokenField(String caption, Layout lo, InsertPosition insertPosition) {
        this(lo);
        this.setCaption(caption);
        this.insertPosition = insertPosition;
    }

    public FTokenField(Layout lo, InsertPosition insertPosition) {
        this(lo);
        this.insertPosition = insertPosition;
    }

    public FTokenField(HasComponents lo) {
        this.cb.setNewItemsAllowed(true);
        this.cb.setNullSelectionAllowed(false);
        this.cb.setClearButtonVisible(false);
        this.cb.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                Object tokenId = event.getProperty().getValue();
                if (tokenId != null && tokenId != FComboBox.NullItemId.INSTANCE) {
                    FTokenField.this.onTokenInput(tokenId);
                    FTokenField.this.cb.setValue((Object)null);
                    FTokenField.this.cb.focus();
                }
            }
        });
        this.cb.setNewItemHandler(new FAbstractSelect.NewItemHandler(){

            @Override
            public void addNewItem(String tokenId) {
                if (FTokenField.this.isReadOnly()) {
                    throw new Property.ReadOnlyException();
                }
                FTokenField.this.onTokenInput(tokenId);
                if (FTokenField.this.rememberNewTokens) {
                    FTokenField.this.rememberToken(tokenId);
                }
                FTokenField.this.cb.focus();
            }
        });
        this.cb.getElement().addEventListener("keydown", (DomEventListener & Serializable)event -> {
            this.cb.blur();
            this.cb.focus();
        }).addEventData("event.key").setFilter("event.key=='" + String.valueOf(Key.ENTER) + "'");
        this.setLayout(lo);
        this.setStyleName("tokenfield tokentextfield");
    }

    protected void rememberToken(String tokenId) {
        if (this.cb.addItem(this.getTokenCaption(tokenId)) != null && this.getTokenCaptionPropertyId() != null) {
            this.cb.getContainerProperty(tokenId, this.getTokenCaptionPropertyId()).setValue(tokenId);
        }
    }

    private void rebuild() {
        this.layout.removeAll();
        if (!this.isReadOnly() && this.insertPosition == InsertPosition.AFTER) {
            this.layout.add(new Component[]{this.cb});
        }
        for (FButton b2 : this.buttons.values()) {
            this.layout.add(new Component[]{b2});
        }
        if (!this.isReadOnly() && this.insertPosition == InsertPosition.BEFORE) {
            this.layout.add(new Component[]{this.cb});
        }
        if (this.layout instanceof HorizontalLayout) {
            ((HorizontalLayout)this.layout).setExpandRatio((Component)this.cb, 1.0f);
        }
    }

    @Override
    protected void setInternalValue(Object newValue) {
        HashSet vals = (HashSet)newValue;
        Set<Object> old = this.buttons.keySet();
        super.setInternalValue(newValue);
        if (old == null) {
            old = new HashSet<Object>();
        }
        if (vals == null) {
            vals = new HashSet();
        }
        HashSet<Object> remove = new HashSet<Object>(old);
        HashSet add = new HashSet(vals);
        remove.removeAll(vals);
        add.removeAll(old);
        for (Object e : remove) {
            this.removeTokenButton(e);
        }
        for (Object e : add) {
            this.addTokenButton(e);
        }
    }

    protected void onTokenInput(Object tokenId) {
        this.addToken(tokenId);
    }

    protected void onTokenClick(Object tokenId) {
        this.removeToken(tokenId);
    }

    protected void onTokenDelete(Object tokenId) {
        this.onTokenClick(tokenId);
    }

    private void addTokenButton(final Object val) {
        FButton b = new FButton();
        this.configureTokenButton(val, b);
        b.addClickListener(new FButton.ClickListener(){

            @Override
            public void buttonClick(FButton.ClickEvent event) {
                FTokenField.this.onTokenClick(val);
            }
        });
        this.buttons.put(val, b);
        if (this.insertPosition == InsertPosition.BEFORE) {
            int index = this.layout.getElement().indexOfChild(this.cb.getElement());
            if (index >= 0) {
                this.layout.addComponentAtIndex(index, (Component)b);
                this.layout.remove(new Component[]{this.cb});
            } else {
                this.layout.add(new Component[]{b});
            }
            this.layout.add(new Component[]{this.cb});
        } else {
            this.layout.add(new Component[]{b});
        }
        if (this.layout instanceof HorizontalLayout) {
            ((HorizontalLayout)this.layout).setExpandRatio((Component)this.cb, 1.0f);
        }
    }

    public void addToken(Object tokenId) {
        LinkedHashSet set = (LinkedHashSet)this.getValue();
        if (set == null) {
            set = new LinkedHashSet();
        }
        if (set.contains(tokenId)) {
            return;
        }
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>(set);
        newSet.add(tokenId);
        this.setValue(newSet);
    }

    public void removeToken(Object tokenId) {
        Set set = (Set)this.getValue();
        LinkedHashSet newSet = new LinkedHashSet(set);
        newSet.remove(tokenId);
        this.setValue(newSet);
    }

    private void removeTokenButton(Object tokenId) {
        FButton button = this.buttons.get(tokenId);
        this.layout.remove(new Component[]{button});
        this.buttons.remove(tokenId);
    }

    protected void configureTokenButton(Object tokenId, FButton button) {
        button.setCaption(this.getTokenCaption(tokenId) + " \u00d7");
        button.setIconResource(this.getTokenIcon(tokenId));
        button.setDescription("Click to remove");
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
    }

    public HasComponents getLayout() {
        return this.layout;
    }

    protected void setLayout(HasComponents newLayout) {
        if (this.layout != null) {
            this.layout.removeAll();
        }
        this.layout = newLayout;
        this.rebuild();
    }

    public InsertPosition getTokenInsertPosition() {
        return this.insertPosition;
    }

    public void setTokenInsertPosition(InsertPosition insertPosition) {
        if (this.insertPosition != insertPosition) {
            this.insertPosition = insertPosition;
            this.rebuild();
        }
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
        return super.addValueChangeListener(valueChangeListener);
    }

    public Optional getOptionalValue() {
        return super.getOptionalValue();
    }

    public void clear() {
        super.clear();
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly == this.isReadOnly()) {
            return;
        }
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.layout.remove(new Component[]{this.cb});
        } else {
            this.rebuild();
        }
    }

    @Override
    public void setContainerDataSource(Container c) {
        this.cb.setContainerDataSource(c);
    }

    @Override
    public Container getContainerDataSource() {
        return this.cb.getContainerDataSource();
    }

    public void setNewTokensAllowed(boolean allowNewTokens) {
        this.cb.setNewItemsAllowed(allowNewTokens);
    }

    public boolean isNewTokensAllowed() {
        return this.cb.isNewItemsAllowed();
    }

    public boolean isRememberNewTokens() {
        return this.rememberNewTokens;
    }

    public void setRememberNewTokens(boolean rememberNewTokens) {
        this.rememberNewTokens = rememberNewTokens;
    }

    public void setFilteringMode(FilteringMode filteringMode) {
        this.cb.setFilteringMode(filteringMode);
    }

    public FilteringMode getFilteringMode() {
        return this.cb.getFilteringMode();
    }

    @Override
    public void focus() {
        this.cb.focus();
    }

    public String getInputPrompt() {
        return this.cb.getPlaceholder();
    }

    public String getTokenCaption(Object tokenId) {
        if (this.cb.containsId(tokenId)) {
            return this.cb.getItemCaption(tokenId);
        }
        return String.valueOf(tokenId);
    }

    public FAbstractSelect.ItemCaptionMode getTokenCaptionMode() {
        return this.cb.getItemCaptionMode();
    }

    public Object getTokenCaptionPropertyId() {
        return this.cb.getItemCaptionPropertyId();
    }

    public Resource getTokenIcon(Object tokenId) {
        return this.cb.getItemIcon(tokenId);
    }

    public Object getTokenIconPropertyId() {
        return this.cb.getItemIconPropertyId();
    }

    public Collection getTokenIds() {
        return this.cb.getItemIds();
    }

    @Override
    public int getTabIndex() {
        return this.cb.getTabIndex();
    }

    @Override
    public void setHeight(float height, Unit unit) {
        if (this.layout != null && this.layout instanceof HasSize) {
            ((HasSize)this.layout).setHeight(height, unit);
        }
        super.setHeight(height, unit);
    }

    @Override
    public void setWidth(float width, Unit unit) {
        if (this.layout != null && this.layout instanceof HasSize) {
            ((HasSize)this.layout).setWidth(width, unit);
        }
        super.setWidth(width, unit);
    }

    @Override
    public void setSizeFull() {
        if (this.layout != null && this.layout instanceof HasSize) {
            ((HasSize)this.layout).setSizeFull();
        }
    }

    @Override
    public void setSizeUndefined() {
        if (this.layout != null && this.layout instanceof HasSize) {
            ((HasSize)this.layout).setSizeUndefined();
        }
    }

    public void setInputHeight(String height) {
        this.cb.setHeight(height);
    }

    public void setInputWidth(String width) {
        this.cb.setWidth(width);
    }

    public void setInputHeight(float height, Unit unit) {
        this.cb.setHeight(height, unit);
    }

    public void setInputWidth(float width, Unit unit) {
        this.cb.setWidth(width, unit);
    }

    public void setInputSizeFull() {
        this.cb.setSizeFull();
    }

    public void setInputSizeUndefined() {
        this.cb.setSizeUndefined();
    }

    public void setInputPrompt(String inputPrompt) {
        this.cb.setPlaceholder(inputPrompt);
    }

    public void setTokenCaption(Object tokenId, String caption) {
        this.cb.setItemCaption(tokenId, caption);
    }

    public void setTokenCaptionMode(FAbstractSelect.ItemCaptionMode mode) {
        this.cb.setItemCaptionMode(mode);
    }

    public void setTokenCaptionPropertyId(Object propertyId) {
        this.cb.setItemCaptionPropertyId(propertyId);
    }

    public void setTokenIcon(Object tokenId, Resource icon) {
        this.cb.setItemIcon(tokenId, icon);
    }

    public void setTokenIconPropertyId(Object propertyId) {
        this.cb.setItemIconPropertyId(propertyId);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.cb.setTabIndex(tabIndex);
    }

    @Override
    public Class<?> getType() {
        return Set.class;
    }

    @Override
    protected Component initContent() {
        return (Component)this.layout;
    }

    public static enum InsertPosition {
        AFTER,
        BEFORE;

    }
}

