/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.ui.FAbstractTextField;
import com.vaadin.featurepack.ui.InputColumnController;
import com.vaadin.featurepack.ui.InputSelectionController;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.featurepack.ui.NullValueController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.textfield.TextArea;
import java.io.Serializable;
import java.util.EventObject;

@CssImport(value="@vaadin/vaadin-lumo-styles/lumo.css")
public class FTextArea
extends TextArea
implements FAbstractTextField {
    private final NullValueController<String> nullValueController = new NullValueController<String>((HasValue<?, String>)this, "null");
    private final InputSelectionController<String> inputSelectionController = new InputSelectionController(this, s -> s);
    private final InputColumnController inputColumnController = new InputColumnController(this);
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");
    private boolean hasDefinedHeight = false;
    private int rows = 5;
    private boolean wordwrap = true;

    public FTextArea() {
        super.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.getNullValueController().processSetValue((String)e.getValue()));
        this.setRows(this.rows);
    }

    public FTextArea(String caption) {
        this();
        this.setCaption(caption);
    }

    public FTextArea(String caption, String value) {
        this();
        this.setCaption(caption);
        this.setValue(value);
    }

    public FTextArea(Property dataSource) {
        this.setPropertyDataSource(dataSource);
    }

    public FTextArea(String caption, Property dataSource) {
        this(dataSource);
        this.setCaption(caption);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public void setHeight(String height) {
        FAbstractTextField.super.setHeight(height);
        this.hasDefinedHeight = height != null;
        this.setRows(this.rows);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        FAbstractTextField.super.setHeight(height, unit);
        boolean bl = this.hasDefinedHeight = height > 0.0f;
        if (!this.hasDefinedHeight) {
            this.setRows(this.rows);
        }
    }

    public void setRows(int rows) {
        this.rows = Math.max(rows, 0);
        if (this.hasDefinedHeight) {
            this.setMaxRows(null);
        } else {
            this.setMaxRows(Math.max(rows, 2));
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setWordwrap(boolean wordwrap) {
        this.wordwrap = wordwrap;
        this.getElement().executeJs("this.inputElement.wrap = $0", new Object[]{wordwrap ? "soft" : "off"});
    }

    public boolean isWordwrap() {
        return this.wordwrap;
    }

    @Override
    public void setValue(String value) {
        super.setValue(this.getNullValueController().processSetValue(value));
    }

    @Override
    public String getValue() {
        return this.getNullValueController().processGetValue(super.getValue());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.getValue() == null;
    }

    public void setLabel(String label) {
        this.labelSlotController.setLabel(label);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
    }

    @Override
    public NullValueController<String> getNullValueController() {
        return this.nullValueController;
    }

    @Override
    public InputSelectionController<String> getInputSelectionController() {
        return this.inputSelectionController;
    }

    @Override
    public InputColumnController getInputColumnController() {
        return this.inputColumnController;
    }

    @Override
    public Class<? extends String> getType() {
        return String.class;
    }

    @Override
    public void clear() {
        super.clear();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractTextField.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }
}

