/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.event.LayoutEvents;
import com.vaadin.featurepack.ui.AbstractLayout;
import com.vaadin.featurepack.util.ComponentDataUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;

@Tag(value="div")
public class CssLayout
extends AbstractLayout
implements LayoutEvents.LayoutClickNotifier {
    protected LinkedList<Component> components = new LinkedList();
    private Component labelComponent;

    public CssLayout() {
    }

    public CssLayout(Component ... children) {
        this();
        this.addComponents(children);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        if (this.labelComponent != null) {
            this.labelComponent.removeFromParent();
        }
        this.labelComponent = labelComponent;
        if (labelComponent != null) {
            this.getElement().insertChild(0, new Element[]{labelComponent.getElement()});
        }
    }

    @Override
    public void addComponent(Component c) {
        this.components.add(c);
        try {
            super.addComponent(c);
        }
        catch (IllegalArgumentException e) {
            this.components.remove(c);
            throw e;
        }
    }

    public void addComponentAsFirst(Component c) {
        if (this.equals(c.getParent().orElse(null))) {
            this.removeComponent(c);
        }
        this.components.addFirst(c);
        try {
            super.addComponent(c);
        }
        catch (IllegalArgumentException e) {
            this.components.remove(c);
            throw e;
        }
    }

    public void addComponent(Component c, int index) {
        if (this.equals(c.getParent().orElse(null))) {
            if (index > this.getComponentIndex(c)) {
                --index;
            }
            this.removeComponent(c);
        }
        this.components.add(index, c);
        try {
            super.addComponent(c);
        }
        catch (IllegalArgumentException e) {
            this.components.remove(c);
            throw e;
        }
    }

    @Override
    public void removeComponent(Component c) {
        this.components.remove(c);
        super.removeComponent(c);
    }

    @Override
    public Iterator<Component> iterator() {
        return this.components.iterator();
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        this.getChildren().filter(c -> c != this.labelComponent).forEach(this::applyCss);
    }

    protected String getCss(Component c) {
        return null;
    }

    private void applyCss(Component c) {
        c.getElement().removeAttribute("style");
        Optional.ofNullable(this.getCss(c)).ifPresent(css -> c.getElement().setAttribute("style", css));
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        int oldLocation = -1;
        int newLocation = -1;
        int location = 0;
        for (Component component : this.components) {
            if (component == oldComponent) {
                oldLocation = location;
            }
            if (component == newComponent) {
                newLocation = location;
            }
            ++location;
        }
        if (oldLocation == -1) {
            this.addComponent(newComponent);
        } else if (newLocation == -1) {
            this.removeComponent(oldComponent);
            this.addComponent(newComponent, oldLocation);
        } else {
            if (oldLocation > newLocation) {
                this.components.remove(oldComponent);
                this.components.add(newLocation, oldComponent);
                this.components.remove(newComponent);
                this.components.add(oldLocation, newComponent);
            } else {
                this.components.remove(newComponent);
                this.components.add(oldLocation, newComponent);
                this.components.remove(oldComponent);
                this.components.add(newLocation, oldComponent);
            }
            this.markAsDirty();
        }
    }

    @Override
    public Registration addLayoutClickListener(LayoutEvents.LayoutClickListener listener) {
        return ComponentDataUtil.put("css-layout-click-listeners", this, listener, ComponentUtil.addListener((Component)this.getFlowComponent(), LayoutEvents.LayoutClickEvent.class, (ComponentEventListener)listener));
    }

    public void removeLayoutClickListener(LayoutEvents.LayoutClickListener listener) {
        ComponentDataUtil.remove("css-layout-click-listeners", this, listener).map(Registration.class::cast).ifPresent(Registration::remove);
    }

    public int getComponentIndex(Component component) {
        return this.components.indexOf(component);
    }

    public Component getComponent(int index) throws IndexOutOfBoundsException {
        return this.components.get(index);
    }
}

