/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import java.io.Serializable;

public final class Alignment
implements Serializable {
    public static final Alignment TOP_RIGHT = new Alignment(6);
    public static final Alignment TOP_LEFT = new Alignment(5);
    public static final Alignment TOP_CENTER = new Alignment(20);
    public static final Alignment MIDDLE_RIGHT = new Alignment(34);
    public static final Alignment MIDDLE_LEFT = new Alignment(33);
    public static final Alignment MIDDLE_CENTER = new Alignment(48);
    public static final Alignment BOTTOM_RIGHT = new Alignment(10);
    public static final Alignment BOTTOM_LEFT = new Alignment(9);
    public static final Alignment BOTTOM_CENTER = new Alignment(24);
    private final int bitMask;

    public Alignment(int bitMask) {
        this.bitMask = bitMask;
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public boolean isTop() {
        return (this.bitMask & 4) == 4;
    }

    public boolean isBottom() {
        return (this.bitMask & 8) == 8;
    }

    public boolean isLeft() {
        return (this.bitMask & 1) == 1;
    }

    public boolean isRight() {
        return (this.bitMask & 2) == 2;
    }

    public boolean isMiddle() {
        return (this.bitMask & 0x20) == 32;
    }

    public boolean isCenter() {
        return (this.bitMask & 0x10) == 16;
    }

    public String getVerticalAlignment() {
        if (this.isBottom()) {
            return "bottom";
        }
        if (this.isMiddle()) {
            return "middle";
        }
        return "top";
    }

    public String getHorizontalAlignment() {
        if (this.isRight()) {
            return "right";
        }
        if (this.isCenter()) {
            return "center";
        }
        return "left";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Alignment a = (Alignment)obj;
        return this.bitMask == a.bitMask;
    }

    public int hashCode() {
        return this.bitMask;
    }

    public String toString() {
        return String.valueOf(this.bitMask);
    }
}

