/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class Helpers
implements Serializable {
    public static final String VAADIN_7_SYSTEM_PROPERTY = "vaadin.classic-components.vaadin7defaults";
    private static final String VAADIN_7_DEFAULTS = System.getProperty("vaadin.classic-components.vaadin7defaults");
    private static final CustomSecurityManager CUSTOM_SECURITY_MANAGER = new CustomSecurityManager();

    private Helpers() {
    }

    static Properties getProperties(VaadinService service) {
        Properties properties = new Properties();
        try {
            properties.load(service.getClassLoader().getResourceAsStream("vaadin-feature-pack-version.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    static boolean isProductionMode(VaadinService service) {
        return service.getDeploymentConfiguration().isProductionMode();
    }

    static VaadinService getService() {
        return VaadinService.getCurrent();
    }

    public static void checkLicense(String projectName, String version) {
        VaadinService service = Helpers.getService();
        if (service != null && !Helpers.isProductionMode(service)) {
            LicenseChecker.checkLicenseFromStaticBlock((String)projectName, (String)version, null);
        }
    }

    public static String getProperty(String property) {
        VaadinService service = Helpers.getService();
        if (service == null) {
            return null;
        }
        Properties properties = Helpers.getProperties(service);
        return properties.getProperty(property);
    }

    public static boolean isVaadin7Defaults() {
        return VAADIN_7_DEFAULTS != null;
    }

    private static class CustomSecurityManager
    extends SecurityManager
    implements Serializable {
        private CustomSecurityManager() {
        }

        public String getFirstNonLegacyClassInCallStack() {
            Class<?>[] classContext = this.getClassContext();
            for (int i = 2; i < classContext.length; ++i) {
                String name = classContext[i].getName();
                if (name.contains("com.vaadin.classic")) continue;
                return name;
            }
            return null;
        }
    }
}

